/*
 * Decompiled with CFR 0.152.
 */
package org.gagravarr.flac;

import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;
import org.gagravarr.flac.FlacAudioFrame;
import org.gagravarr.flac.FlacFirstOggPacket;
import org.gagravarr.flac.FlacInfo;
import org.gagravarr.flac.FlacNativeFile;
import org.gagravarr.flac.FlacOggFile;
import org.gagravarr.flac.FlacTags;
import org.gagravarr.ogg.OggFile;

public class TestFlacFileRead
extends TestCase {
    private InputStream getTestOggFile() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/testFLAC.oga");
    }

    private InputStream getTestFlacFile() throws IOException {
        return ((Object)((Object)this)).getClass().getResourceAsStream("/testFLAC.flac");
    }

    public void testReadOgg() throws IOException {
        OggFile ogg = new OggFile(this.getTestOggFile());
        FlacOggFile flac = new FlacOggFile(ogg);
        FlacFirstOggPacket first = flac.getFirstPacket();
        TestFlacFileRead.assertNotNull((Object)first);
        TestFlacFileRead.assertEquals((int)1, (int)first.getMajorVersion());
        TestFlacFileRead.assertEquals((int)0, (int)first.getMinorVersion());
        FlacInfo info = flac.getInfo();
        TestFlacFileRead.assertNotNull((Object)info);
        TestFlacFileRead.assertEquals((int)4096, (int)info.getMinimumBlockSize());
        TestFlacFileRead.assertEquals((int)4096, (int)info.getMaximumBlockSize());
        TestFlacFileRead.assertEquals((int)2126, (int)info.getMinimumFrameSize());
        TestFlacFileRead.assertEquals((int)2126, (int)info.getMaximumFrameSize());
        TestFlacFileRead.assertEquals((int)44100, (int)info.getSampleRate());
        TestFlacFileRead.assertEquals((int)16, (int)info.getBitsPerSample());
        TestFlacFileRead.assertEquals((int)2, (int)info.getNumChannels());
        TestFlacFileRead.assertEquals((long)960L, (long)info.getNumberOfSamples());
        FlacTags tags = flac.getTags();
        TestFlacFileRead.assertNotNull((Object)tags);
        TestFlacFileRead.assertEquals((int)7, (int)tags.getAllComments().size());
        TestFlacFileRead.assertEquals((String)"Test Album", (String)tags.getAlbum());
        TestFlacFileRead.assertNotNull((Object)flac.getNextAudioPacket());
        FlacAudioFrame ad = flac.getNextAudioPacket();
    }

    public void testReadFlacNative() throws IOException {
        FlacNativeFile flac = new FlacNativeFile(this.getTestFlacFile());
        FlacInfo info = flac.getInfo();
        TestFlacFileRead.assertNotNull((Object)info);
        TestFlacFileRead.assertEquals((int)4096, (int)info.getMinimumBlockSize());
        TestFlacFileRead.assertEquals((int)4096, (int)info.getMaximumBlockSize());
        TestFlacFileRead.assertEquals((int)2126, (int)info.getMinimumFrameSize());
        TestFlacFileRead.assertEquals((int)2126, (int)info.getMaximumFrameSize());
        TestFlacFileRead.assertEquals((int)44100, (int)info.getSampleRate());
        TestFlacFileRead.assertEquals((int)16, (int)info.getBitsPerSample());
        TestFlacFileRead.assertEquals((int)2, (int)info.getNumChannels());
        TestFlacFileRead.assertEquals((long)960L, (long)info.getNumberOfSamples());
        FlacTags tags = flac.getTags();
        TestFlacFileRead.assertNotNull((Object)tags);
        TestFlacFileRead.assertEquals((int)7, (int)tags.getAllComments().size());
        TestFlacFileRead.assertEquals((String)"Test Album", (String)tags.getAlbum());
        TestFlacFileRead.assertNotNull((Object)flac.getNextAudioPacket());
        FlacAudioFrame ad = flac.getNextAudioPacket();
    }
}

