/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_0_0_Plus;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.wcs.v1_0_0_Plus.AxisSubset;
import thredds.wcs.v1_0_0_Plus.WcsCoverage;
import thredds.wcs.v1_0_0_Plus.WcsDataset;
import thredds.wcs.v1_0_0_Plus.WcsException;
import thredds.wcs.v1_0_0_Plus.WcsRequest;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ogc.EPSG_OGC_CF_Helper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetCoverage
extends WcsRequest {
    private static Logger log = LoggerFactory.getLogger(GetCoverage.class);
    private WcsCoverage coverage;
    private LatLonRect requestLatLonBBox;
    private AxisSubset requestVertSubset;
    private DateRange timeRange;
    private List<String> rangeSubset;
    private WcsRequest.Format format;
    private boolean isSingleTimeRequest = false;
    private boolean isSingleVerticalRequest = false;
    private boolean isSingleRangeFieldRequest = false;

    public GetCoverage(WcsRequest.Operation operation, String version, WcsDataset dataset, String coverageId, String crs, String responseCRS, String bbox, String time, String rangeSubset, String format) throws WcsException {
        super(operation, version, dataset);
        if (coverageId == null) {
            throw new WcsException(WcsException.Code.MissingParameterValue, "coverage", "Coverage identifier required.");
        }
        if (!this.getDataset().isAvailableCoverageName(coverageId)) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "coverage", "Unknown coverage identifier <" + coverageId + ">.");
        }
        this.coverage = this.getDataset().getAvailableCoverage(coverageId);
        if (this.coverage == null) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "coverage", "Unknown coverage identifier <" + coverageId + ">.");
        }
        if (crs == null) {
            throw new WcsException(WcsException.Code.MissingParameterValue, "CRS", "Request CRS required.");
        }
        if (!crs.equalsIgnoreCase(this.coverage.getDefaultRequestCrs())) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "CRS", "Request CRS <" + crs + "> not allowed <" + this.coverage.getDefaultRequestCrs() + ">.");
        }
        String nativeCRS = EPSG_OGC_CF_Helper.getWcs1_0CrsId(this.coverage.getCoordinateSystem().getProjection());
        if (nativeCRS == null) {
            throw new WcsException(WcsException.Code.CoverageNotDefined, "", "Coverage not in recognized CRS. (???)");
        }
        if (responseCRS == null) {
            if (!nativeCRS.equalsIgnoreCase(this.coverage.getDefaultRequestCrs())) {
                throw new WcsException(WcsException.Code.MissingParameterValue, "Response_CRS", "Response CRS required.");
            }
        } else if (!responseCRS.equalsIgnoreCase(nativeCRS)) {
            throw new WcsException(WcsException.Code.InvalidParameterValue, "response_CRS", "Respnse CRS <" + responseCRS + "> not allowed <" + nativeCRS + ">.");
        }
        if (bbox != null && !bbox.equals("")) {
            String[] bboxSplit = this.splitBoundingBox(bbox);
            this.requestLatLonBBox = this.genRequestLatLonBoundingBox(bboxSplit, this.coverage.getCoordinateSystem());
            CoordinateAxis1D vertAxis = this.coverage.getCoordinateSystem().getVerticalAxis();
            if (vertAxis != null) {
                this.requestVertSubset = this.genRequestVertSubset(bboxSplit, vertAxis);
            }
        }
        if (time != null && !time.equals("")) {
            this.timeRange = this.parseTime(time);
        }
        this.rangeSubset = this.parseRangeSubset(rangeSubset);
        if (format == null || format.equals("")) {
            log.error("GetCoverage(): FORMAT parameter required.");
            throw new WcsException(WcsException.Code.InvalidParameterValue, "FORMAT", "FORMAT parameter required.");
        }
        try {
            this.format = WcsRequest.Format.valueOf(format.trim());
        }
        catch (IllegalArgumentException e) {
            String msg = "Unknown format value [" + format + "].";
            log.error("GetCoverage(): " + msg);
            throw new WcsException(WcsException.Code.InvalidParameterValue, "FORMAT", msg);
        }
        if (!this.coverage.isSupportedCoverageFormat(this.format)) {
            String msg = "Unsupported format value [" + format + "].";
            log.error("GetCoverage(): " + msg);
            throw new WcsException(WcsException.Code.InvalidParameterValue, "FORMAT", msg);
        }
        if (!(this.format != WcsRequest.Format.GeoTIFF && this.format != WcsRequest.Format.GeoTIFF_Float || this.isSingleTimeRequest || this.isSingleVerticalRequest || this.isSingleRangeFieldRequest)) {
            StringBuffer msgB = new StringBuffer("GeoTIFF supported only for requests at a single time [");
            if (time != null) {
                msgB.append(time);
            }
            msgB.append("] and a single vertical level [");
            if (bbox != null) {
                msgB.append(bbox);
            }
            msgB.append("] and a single range field [");
            if (rangeSubset != null) {
                msgB.append(rangeSubset);
            }
            msgB.append("].");
            log.error("GetCoverage(): " + msgB);
            throw new WcsException(WcsException.Code.InvalidParameterValue, "FORMAT", msgB.toString());
        }
    }

    public WcsRequest.Format getFormat() {
        return this.format;
    }

    public File writeCoverageDataToFile() throws WcsException {
        return this.coverage.writeCoverageDataToFile(this.format, this.requestLatLonBBox, this.requestVertSubset, this.rangeSubset, this.timeRange);
    }

    private String[] splitBoundingBox(String bbox) throws WcsException {
        if (bbox == null || bbox.equals("")) {
            return null;
        }
        String[] bboxSplit = bbox.split(",");
        if (bboxSplit.length != 4 && bboxSplit.length != 6) {
            log.error("splitBoundingBox(): BBOX <" + bbox + "> must be \"minx,miny,maxx,maxy[,minz,maxz]\".");
            throw new WcsException(WcsException.Code.InvalidParameterValue, "BBOX", "BBOX <" + bbox + "> not in expected format \"minx,miny,maxx,maxy[,minz,maxz]\".");
        }
        return bboxSplit;
    }

    private LatLonRect genRequestLatLonBoundingBox(String[] bboxSplit, GridCoordSystem gcs) throws WcsException {
        if (bboxSplit == null || gcs == null) {
            return null;
        }
        if (bboxSplit.length < 4) {
            throw new IllegalArgumentException("BBOX contains fewer than four items \"" + bboxSplit.toString() + "\".");
        }
        double minx = 0.0;
        double miny = 0.0;
        double maxx = 0.0;
        double maxy = 0.0;
        try {
            minx = Double.parseDouble(bboxSplit[0]);
            miny = Double.parseDouble(bboxSplit[1]);
            maxx = Double.parseDouble(bboxSplit[2]);
            maxy = Double.parseDouble(bboxSplit[3]);
        }
        catch (NumberFormatException e) {
            String message = "BBOX item(s) have incorrect number format [not double] <" + bboxSplit.toString() + ">.";
            log.error("genRequestLatLonBoundingBox(): " + message + " - " + e.getMessage());
            throw new WcsException(WcsException.Code.InvalidParameterValue, "BBOX", message);
        }
        LatLonPointImpl minll = new LatLonPointImpl(miny, minx);
        LatLonPointImpl maxll = new LatLonPointImpl(maxy, maxx);
        LatLonRect requestLatLonRect = new LatLonRect(minll, maxll);
        LatLonRect covLatLonRect = gcs.getLatLonBoundingBox();
        return requestLatLonRect;
    }

    private AxisSubset genRequestVertSubset(String[] bboxSplit, CoordinateAxis1D vertAxis) throws WcsException {
        if (bboxSplit == null || bboxSplit.length == 4) {
            if (vertAxis == null || vertAxis.getShape(0) == 1) {
                this.isSingleVerticalRequest = true;
            }
            return null;
        }
        if (bboxSplit.length != 6) {
            String message = "BBOX must have 4 or 6 items [" + bboxSplit.toString() + "].";
            log.error("genRequestVertSubset(): " + message);
            throw new WcsException(WcsException.Code.InvalidParameterValue, "BBOX", message);
        }
        if (vertAxis == null || vertAxis.getShape(0) == 1) {
            this.isSingleVerticalRequest = true;
            return null;
        }
        double minz = 0.0;
        double maxz = 0.0;
        try {
            minz = Double.parseDouble(bboxSplit[4]);
            maxz = Double.parseDouble(bboxSplit[5]);
        }
        catch (NumberFormatException e) {
            String message = "BBOX item(s) have incorrect number format (not double) [" + bboxSplit.toString() + "].";
            log.error("genRequestVertSubset(): " + message + " - " + e.getMessage());
            throw new WcsException(WcsException.Code.InvalidParameterValue, "BBOX", message);
        }
        AxisSubset axisSubset = new AxisSubset(vertAxis, minz, maxz, 1);
        Range range = null;
        try {
            range = axisSubset.getRange();
        }
        catch (InvalidRangeException e) {
            String message = "BBOX results in invalid array index range [" + bboxSplit.toString() + "].";
            log.error("genRequestVertSubset(): " + message + " - " + e.getMessage());
            throw new WcsException(WcsException.Code.InvalidParameterValue, "BBOX", message);
        }
        if (range.length() == 1) {
            this.isSingleVerticalRequest = true;
            return null;
        }
        return axisSubset;
    }

    private DateRange parseTime(String time) throws WcsException {
        DateRange dateRange;
        if (time == null || time.equals("")) {
            return null;
        }
        try {
            if (time.indexOf(",") != -1) {
                log.error("parseTime(): Unsupported time parameter (list) <" + time + ">.");
                throw new WcsException(WcsException.Code.InvalidParameterValue, "TIME", "Not currently supporting time list.");
            }
            if (time.indexOf("/") != -1) {
                String[] timeRange = time.split("/");
                if (timeRange.length != 2) {
                    log.error("parseTime(): Unsupported time parameter (time range with resolution) <" + time + ">.");
                    throw new WcsException(WcsException.Code.InvalidParameterValue, "TIME", "Not currently supporting time range with resolution.");
                }
                dateRange = new DateRange(new DateType(timeRange[0], null, null), new DateType(timeRange[1], null, null), null, null);
            } else {
                DateType date = new DateType(time, null, null);
                dateRange = new DateRange(date, date, null, null);
                this.isSingleTimeRequest = true;
            }
        }
        catch (ParseException e) {
            log.error("parseTime(): Failed to parse time parameter <" + time + ">: " + e.getMessage());
            throw new WcsException(WcsException.Code.InvalidParameterValue, "TIME", "Invalid time format <" + time + ">.");
        }
        return dateRange;
    }

    private List<String> parseRangeSubset(String rangeSubset) throws WcsException {
        ArrayList<String> response = new ArrayList<String>();
        if (rangeSubset == null || rangeSubset.equals("")) {
            response.addAll(this.coverage.getRangeFieldNames());
            if (response.size() == 1) {
                this.isSingleRangeFieldRequest = true;
            }
            return response;
        }
        String[] fieldSubsetArray = rangeSubset.indexOf(";") == -1 ? new String[]{rangeSubset} : rangeSubset.split(";");
        for (String curFieldSubset : fieldSubsetArray) {
            if (!this.coverage.isRangeFieldName(curFieldSubset)) {
                String message = "Requested range field <" + curFieldSubset + "> not available.";
                log.warn("parseRangeSubset(): " + message);
                throw new WcsException(WcsException.Code.InvalidParameterValue, "RangeSubset", message);
            }
            response.add(curFieldSubset);
        }
        if (response.size() == 1) {
            this.isSingleRangeFieldRequest = true;
        }
        return response;
    }
}

