/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.css;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.XRefChecker;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.util.Messages;
import com.adobe.epubcheck.util.PathUtil;
import com.google.common.base.CharMatcher;
import java.util.List;
import org.idpf.epubcheck.util.css.CssContentHandler;
import org.idpf.epubcheck.util.css.CssErrorHandler;
import org.idpf.epubcheck.util.css.CssExceptions;
import org.idpf.epubcheck.util.css.CssGrammar;

public class CSSHandler
implements CssContentHandler,
CssErrorHandler {
    private final String path;
    private final XRefChecker xrefChecker;
    private final Report report;
    private final EPUBVersion version;
    private int lineOffset = 0;
    private CharMatcher SPACE_AND_QUOTES = CharMatcher.anyOf((CharSequence)" \t\n\r\f\"'").precomputed();
    String fontFamily;
    String fontStyle;
    String fontWeight;
    String fontUri;
    boolean inFontFace = false;

    public CSSHandler(String path, XRefChecker xrefChecker, Report report, EPUBVersion version) {
        this.path = path;
        this.xrefChecker = xrefChecker;
        this.report = report;
        this.version = version;
    }

    @Override
    public void error(CssExceptions.CssException e) throws CssExceptions.CssException {
        this.report.warning(this.path, e.getLocation().getLine() + this.lineOffset, -1, e.getMessage());
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startAtRule(CssGrammar.CssAtRule atRule) {
        if (atRule.getName().get() == "@import") {
            CssGrammar.CssConstruct uriOrString = (CssGrammar.CssConstruct)atRule.getComponents().get(0);
            if (uriOrString != null) {
                int line = uriOrString.getLocation().getLine();
                int col = uriOrString.getLocation().getColumn();
                if (uriOrString.getType() == CssGrammar.CssConstruct.Type.URI) {
                    this.resolveAndRegister(((CssGrammar.CssURI)uriOrString).toUriString(), line, col);
                } else if (uriOrString.getType() == CssGrammar.CssConstruct.Type.STRING) {
                    String uri = CharMatcher.anyOf((CharSequence)"\"'").trimFrom((CharSequence)uriOrString.toCssString());
                    this.resolveAndRegister(uri, line, col);
                }
            }
        } else if (atRule.getName().get() != "@namespace") {
            this.registerURIs(atRule.getComponents(), atRule.getLocation().getLine(), atRule.getLocation().getColumn());
        }
        if (atRule.getName().get() == "@font-face") {
            this.inFontFace = true;
        }
    }

    @Override
    public void endAtRule(String name) {
        if (name == "@font-face") {
            this.inFontFace = false;
            this.handleFontFaceInfo();
        }
    }

    @Override
    public void selectors(List<CssGrammar.CssSelector> selectors) {
    }

    @Override
    public void declaration(CssGrammar.CssDeclaration declaration) {
        this.registerURIs(declaration.getComponents(), declaration.getLocation().getLine(), declaration.getLocation().getColumn());
        String propertyName = (String)declaration.getName().get();
        if (propertyName == null) {
            return;
        }
        if (this.version == EPUBVersion.VERSION_3) {
            int line = declaration.getLocation().getLine() + this.lineOffset;
            int col = declaration.getLocation().getColumn();
            if (propertyName == "position") {
                String value;
                CssGrammar.CssConstruct cns = (CssGrammar.CssConstruct)declaration.getComponents().get(0);
                if (cns != null && (value = cns.toCssString()) != null && value.equalsIgnoreCase("fixed")) {
                    this.report.warning(this.path, line, col, Messages.POSITION_FIXED);
                }
            } else if (propertyName == "direction" || propertyName == "unicode-bidi") {
                this.report.error(this.path, line, col, String.format(Messages.CSS_PROPERTY_NOT_ALLOWED, propertyName));
            }
        }
        if (this.inFontFace) {
            if (propertyName == "font-family") {
                CssGrammar.CssConstruct cc = (CssGrammar.CssConstruct)declaration.getComponents().get(0);
                if (cc != null) {
                    this.fontFamily = this.SPACE_AND_QUOTES.trimFrom((CharSequence)cc.toCssString());
                }
            } else if (propertyName == "font-style") {
                CssGrammar.CssConstruct cc = (CssGrammar.CssConstruct)declaration.getComponents().get(0);
                this.fontStyle = cc.toCssString();
            } else if (propertyName == "font-weight") {
                CssGrammar.CssConstruct cc = (CssGrammar.CssConstruct)declaration.getComponents().get(0);
                this.fontWeight = cc.toCssString();
            } else if (propertyName == "src") {
                for (CssGrammar.CssConstruct construct : declaration.getComponents()) {
                    if (construct.getType() != CssGrammar.CssConstruct.Type.URI) continue;
                    this.fontUri = ((CssGrammar.CssURI)construct).toUriString();
                    String fontMimeType = this.xrefChecker.getMimeType(this.fontUri);
                    if (fontMimeType == null) continue;
                    boolean blessed = true;
                    if (this.version == EPUBVersion.VERSION_2) {
                        blessed = OPFChecker.isBlessedFontMimetype20(fontMimeType);
                    } else if (this.version == EPUBVersion.VERSION_3) {
                        blessed = OPFChecker30.isBlessedFontType(fontMimeType);
                    }
                    if (blessed) continue;
                    this.report.warning(this.path, declaration.getLocation().getLine(), declaration.getLocation().getColumn(), String.format(Messages.CSS_FONT_MIMETYPE, this.fontUri, fontMimeType));
                }
            }
        }
    }

    private void registerURIs(List<CssGrammar.CssConstruct> constructs, int line, int col) {
        for (CssGrammar.CssConstruct construct : constructs) {
            if (construct.getType() != CssGrammar.CssConstruct.Type.URI) continue;
            this.resolveAndRegister(((CssGrammar.CssURI)construct).toUriString(), line, col);
        }
    }

    private void resolveAndRegister(String relativeRef, int line, int col) {
        if (relativeRef != null && relativeRef.trim().length() > 0) {
            String resolved = PathUtil.resolveRelativeReference(this.path, relativeRef, null);
            this.xrefChecker.registerReference(this.path, line + this.lineOffset, col, resolved, 0);
        } else {
            this.report.error(this.path, line + this.lineOffset, col, Messages.NULL_REF);
        }
    }

    private void handleFontFaceInfo() {
        if (this.fontFamily != null) {
            if (this.fontUri != null && !this.fontUri.startsWith("http")) {
                this.report.info(this.path, FeatureEnum.FONT_EMBEDDED, this.fontFamily + (this.fontStyle != null && !"normal".equalsIgnoreCase(this.fontStyle) ? "," + this.fontStyle : "") + (this.fontWeight != null && !"normal".equalsIgnoreCase(this.fontWeight) ? "," + this.fontWeight : ""));
            } else {
                this.report.info(this.path, FeatureEnum.FONT_REFERENCE, this.fontFamily + (this.fontStyle != null && !"normal".equalsIgnoreCase(this.fontStyle) ? "," + this.fontStyle : "") + (this.fontWeight != null && !"normal".equalsIgnoreCase(this.fontWeight) ? "," + this.fontWeight : ""));
                this.report.info(this.path, FeatureEnum.REFERENCE, this.fontUri);
            }
        }
    }

    public void setLineOffset(int offset) {
        this.lineOffset = offset - 1;
        if (this.lineOffset < 0) {
            this.lineOffset = 0;
        }
    }
}

