/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ContentHandlerProxy;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.StreamWriterToReceiver;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.serialize.CDATAFilter;
import net.sf.saxon.serialize.CharacterMapExpander;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.HTMLEmitter;
import net.sf.saxon.serialize.HTMLIndenter;
import net.sf.saxon.serialize.HTMLURIEscaper;
import net.sf.saxon.serialize.MetaTagAdjuster;
import net.sf.saxon.serialize.TEXTEmitter;
import net.sf.saxon.serialize.UncommittedSerializer;
import net.sf.saxon.serialize.UnicodeNormalizer;
import net.sf.saxon.serialize.XHTMLEmitter;
import net.sf.saxon.serialize.XHTMLURIEscaper;
import net.sf.saxon.serialize.XML10ContentChecker;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.serialize.XMLIndenter;
import net.sf.saxon.trans.XPathException;

public class SerializerFactory
implements Serializable {
    Configuration config;

    public SerializerFactory(Configuration config) {
        this.config = config;
    }

    public StreamWriterToReceiver getXMLStreamWriter(StreamResult result, Properties properties) throws XPathException {
        Receiver r = this.getReceiver(result, this.config.makePipelineConfiguration(), properties);
        return new StreamWriterToReceiver(r);
    }

    public Receiver getReceiver(Result result, PipelineConfiguration pipe, Properties props) throws XPathException {
        if (pipe.getController() != null) {
            return this.getReceiver(result, pipe, props, pipe.getController().getExecutable().getCharacterMapIndex());
        }
        return this.getReceiver(result, pipe, props, null);
    }

    public Receiver getReceiver(Result result, PipelineConfiguration pipe, Properties props, CharacterMapIndex charMapIndex) throws XPathException {
        if (result instanceof Emitter) {
            if (((Emitter)result).getOutputProperties() == null) {
                ((Emitter)result).setOutputProperties(props);
            }
            return (Emitter)result;
        }
        if (result instanceof Receiver) {
            Receiver receiver = (Receiver)result;
            receiver.setSystemId(result.getSystemId());
            receiver.setPipelineConfiguration(pipe);
            return receiver;
        }
        if (result instanceof SAXResult) {
            ContentHandlerProxy proxy = this.newContentHandlerProxy();
            proxy.setUnderlyingContentHandler(((SAXResult)result).getHandler());
            proxy.setPipelineConfiguration(pipe);
            proxy.setOutputProperties(props);
            if ("yes".equals(props.getProperty("{http://saxon.sf.net/}supply-source-locator"))) {
                if (pipe.getConfiguration().isCompileWithTracing()) {
                    pipe.getController().addTraceListener(proxy.getTraceListener());
                } else {
                    XPathException de = new XPathException("Cannot use saxon:supply-source-locator unless tracing was enabled at compile time");
                    de.setErrorCode("SXSE0002");
                    throw de;
                }
            }
            return proxy;
        }
        if (result instanceof StreamResult) {
            Receiver target;
            String method = props.getProperty("method");
            if (method == null) {
                return this.newUncommittedSerializer(result, new Sink(pipe), props);
            }
            Emitter emitter = null;
            CharacterMapExpander characterMapExpander = null;
            String useMaps = props.getProperty("use-character-maps");
            if (useMaps != null) {
                if (charMapIndex == null) {
                    XPathException de = new XPathException("Cannot use character maps in an environment with no Controller");
                    de.setErrorCode("SXSE0001");
                    throw de;
                }
                characterMapExpander = charMapIndex.makeCharacterMapExpander(useMaps, new Sink(pipe), this);
            }
            ProxyReceiver normalizer = null;
            String normForm = props.getProperty("normalization-form");
            if (normForm != null && !normForm.equals("none")) {
                normalizer = this.newUnicodeNormalizer(new Sink(pipe), props);
            }
            if ("html".equals(method)) {
                emitter = this.newHTMLEmitter(props);
                emitter.setPipelineConfiguration(pipe);
                target = this.createHTMLSerializer(emitter, props, pipe, characterMapExpander, normalizer);
            } else if ("xml".equals(method)) {
                emitter = this.newXMLEmitter(props);
                emitter.setPipelineConfiguration(pipe);
                target = this.createXMLSerializer((XMLEmitter)emitter, props, pipe, characterMapExpander, normalizer);
            } else if ("xhtml".equals(method)) {
                emitter = this.newXHTMLEmitter(props);
                emitter.setPipelineConfiguration(pipe);
                target = this.createXHTMLSerializer(emitter, props, pipe, characterMapExpander, normalizer);
            } else if ("text".equals(method)) {
                emitter = this.newTEXTEmitter();
                emitter.setPipelineConfiguration(pipe);
                target = this.createTextSerializer(emitter, props, characterMapExpander, normalizer);
            } else if (method.startsWith("{http://saxon.sf.net/}")) {
                target = this.createSaxonSerializationMethod(method, props, pipe, characterMapExpander, normalizer);
                if (target instanceof Emitter) {
                    emitter = (Emitter)target;
                }
            } else {
                Receiver userReceiver;
                if (pipe == null) {
                    throw new XPathException("Unsupported serialization method " + method);
                }
                target = userReceiver = this.createUserDefinedOutputMethod(method, props, pipe);
                if (userReceiver instanceof Emitter) {
                    emitter = (Emitter)userReceiver;
                } else {
                    return userReceiver;
                }
            }
            if (emitter != null) {
                emitter.setOutputProperties(props);
                StreamResult sr = (StreamResult)result;
                emitter.setStreamResult(sr);
            }
            return target;
        }
        if (pipe != null) {
            List<ExternalObjectModel> externalObjectModels = pipe.getConfiguration().getExternalObjectModels();
            for (ExternalObjectModel externalObjectModel : externalObjectModels) {
                ExternalObjectModel model = externalObjectModel;
                Receiver builder = model.getDocumentBuilder(result);
                if (builder == null) continue;
                builder.setSystemId(result.getSystemId());
                builder.setPipelineConfiguration(pipe);
                return builder;
            }
        }
        throw new IllegalArgumentException("Unknown type of result: " + result.getClass());
    }

    protected Receiver createHTMLSerializer(Emitter emitter, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        Receiver target = emitter;
        if (!"no".equals(props.getProperty("indent"))) {
            target = this.newHTMLIndenter(target, props);
        }
        if (normalizer != null) {
            normalizer.setUnderlyingReceiver(target);
            target = normalizer;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(target);
            target = characterMapExpander;
        }
        if (!"no".equals(props.getProperty("escape-uri-attributes"))) {
            target = this.newHTMLURIEscaper(target, props);
        }
        if (!"no".equals(props.getProperty("include-content-type"))) {
            target = this.newHTMLMetaTagAdjuster(target, props);
        }
        return target;
    }

    protected Receiver createTextSerializer(Emitter emitter, Properties props, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        Receiver target = emitter;
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(target);
            characterMapExpander.setUseNullMarkers(false);
            target = characterMapExpander;
        }
        if (normalizer != null) {
            normalizer.setUnderlyingReceiver(target);
            target = normalizer;
        }
        target = this.addTextOutputFilter(target, props);
        return target;
    }

    protected Receiver createXHTMLSerializer(Emitter emitter, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        String cdataElements;
        pipe.getConfiguration().getNamePool().allocateCodeForURI("http://www.w3.org/1999/xhtml");
        Receiver target = emitter;
        if (!"no".equals(props.getProperty("indent"))) {
            target = this.newXHTMLIndenter(target, props);
        }
        if (normalizer != null) {
            normalizer.setUnderlyingReceiver(target);
            target = normalizer;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(target);
            characterMapExpander.setPipelineConfiguration(pipe);
            target = characterMapExpander;
        }
        if ((cdataElements = props.getProperty("cdata-section-elements")) != null && cdataElements.length() > 0) {
            target = this.newCDATAFilter(target, props);
        }
        if (!"no".equals(props.getProperty("escape-uri-attributes"))) {
            target = this.newXHTMLURIEscaper(target, props);
        }
        if (!"no".equals(props.getProperty("include-content-type"))) {
            target = this.newXHTMLMetaTagAdjuster(target, props);
        }
        return target;
    }

    protected Receiver createXMLSerializer(XMLEmitter emitter, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        String cdataElements;
        Receiver target = "yes".equals(props.getProperty("indent")) ? this.newXMLIndenter(emitter, props) : emitter;
        if ("1.0".equals(props.getProperty("version")) && pipe.getConfiguration().getXMLVersion() == 11) {
            target = this.newXML10ContentChecker(target, props);
        }
        if (normalizer != null) {
            normalizer.setUnderlyingReceiver(target);
            target = normalizer;
        }
        if (characterMapExpander != null) {
            characterMapExpander.setUnderlyingReceiver(target);
            target = characterMapExpander;
        }
        if ((cdataElements = props.getProperty("cdata-section-elements")) != null && cdataElements.length() > 0) {
            target = this.newCDATAFilter(target, props);
        }
        return target;
    }

    protected Receiver createSaxonSerializationMethod(String method, Properties props, PipelineConfiguration pipe, CharacterMapExpander characterMapExpander, ProxyReceiver normalizer) throws XPathException {
        throw new XPathException("Saxon serialization methods require Saxon-PE to be enabled");
    }

    protected Receiver createUserDefinedOutputMethod(String method, Properties props, PipelineConfiguration pipe) throws XPathException {
        Receiver userReceiver = pipe.getConfiguration().makeEmitter(method, props);
        userReceiver.setPipelineConfiguration(pipe);
        if (userReceiver instanceof ContentHandlerProxy && "yes".equals(props.getProperty("{http://saxon.sf.net/}supply-source-locator"))) {
            if (pipe.getConfiguration().isCompileWithTracing()) {
                pipe.getController().addTraceListener(((ContentHandlerProxy)userReceiver).getTraceListener());
            } else {
                XPathException de = new XPathException("Cannot use saxon:supply-source-locator unless tracing was enabled at compile time");
                de.setErrorCode("SXSE0002");
                throw de;
            }
        }
        return userReceiver;
    }

    protected ContentHandlerProxy newContentHandlerProxy() {
        return new ContentHandlerProxy();
    }

    protected UncommittedSerializer newUncommittedSerializer(Result result, Receiver next, Properties properties) {
        return new UncommittedSerializer(result, next, properties);
    }

    protected Emitter newXMLEmitter(Properties properties) {
        return new XMLEmitter();
    }

    protected Emitter newHTMLEmitter(Properties properties) {
        return new HTMLEmitter();
    }

    protected Emitter newXHTMLEmitter(Properties properties) {
        return new XHTMLEmitter();
    }

    public Receiver addTextOutputFilter(Receiver next, Properties properties) throws XPathException {
        return next;
    }

    protected Emitter newTEXTEmitter() {
        return new TEXTEmitter();
    }

    protected ProxyReceiver newXMLIndenter(XMLEmitter next, Properties outputProperties) {
        XMLIndenter r = new XMLIndenter(next);
        r.setOutputProperties(outputProperties);
        return r;
    }

    protected ProxyReceiver newHTMLIndenter(Receiver next, Properties outputProperties) {
        return new HTMLIndenter(next, "html");
    }

    protected ProxyReceiver newXHTMLIndenter(Receiver next, Properties outputProperties) {
        return new HTMLIndenter(next, "xhtml");
    }

    protected MetaTagAdjuster newXHTMLMetaTagAdjuster(Receiver next, Properties outputProperties) {
        MetaTagAdjuster r = new MetaTagAdjuster(next);
        r.setOutputProperties(outputProperties);
        r.setIsXHTML(true);
        return r;
    }

    protected MetaTagAdjuster newHTMLMetaTagAdjuster(Receiver next, Properties outputProperties) {
        MetaTagAdjuster r = new MetaTagAdjuster(next);
        r.setOutputProperties(outputProperties);
        r.setIsXHTML(false);
        return r;
    }

    protected ProxyReceiver newHTMLURIEscaper(Receiver next, Properties outputProperties) {
        return new HTMLURIEscaper(next);
    }

    protected ProxyReceiver newXHTMLURIEscaper(Receiver next, Properties outputProperties) {
        return new XHTMLURIEscaper(next);
    }

    protected ProxyReceiver newCDATAFilter(Receiver next, Properties outputProperties) throws XPathException {
        CDATAFilter r = new CDATAFilter(next);
        r.setOutputProperties(outputProperties);
        return r;
    }

    protected ProxyReceiver newXML10ContentChecker(Receiver next, Properties outputProperties) {
        return new XML10ContentChecker(next);
    }

    protected ProxyReceiver newUnicodeNormalizer(Receiver next, Properties outputProperties) throws XPathException {
        String normForm = outputProperties.getProperty("normalization-form");
        return new UnicodeNormalizer(normForm, next);
    }

    public CharacterMapExpander newCharacterMapExpander(Receiver next) {
        return new CharacterMapExpander(next);
    }

    public Result prepareNextStylesheet(Controller controller, String href, String baseURI, Result result) throws TransformerException {
        controller.getConfiguration().checkLicensedFeature(8, "saxon:next-in-chain");
        return null;
    }
}

