#!perl
use 5.008;

use strict;
use warnings;
use utf8;

use lib qw(../lib/);

use Test::More;

my $class = 'Text::Guess::Language';

use_ok($class);

my $text =<<TEXT;

OPĆA DEKLARACIJA O PRAVIMA ČOVJEKA
USVOJENA U OPĆOJ SKUPŠTINI UJEDINJENIH NACIJA 10. DECEMBRA

UVOD
BUDUĆI da su priznavanje urođenog dostojanstva i jednakih i neotuđivih prava svih članova ljudske obitelji temelj slobode, pravde i mira u svijetu,

BUDUĆI da su nepoštivanje i preziranje prava čovjeka imali za posljedicu akte, koji su grubo vrijeđali savjest čovječanstva, i budući da je stvaranje svijeta u kojem će ljudska bića uživati slobodu govora i vjerovanja i slobodu od straha i nestašice bilo proglašeno kao najviša težnja običnih ljudi,

BUDUĆI da je bitno da prava čovjeka budu zastićena vladavinom prava, da čovjek ne bude primoran da kao posljednjem sredstvu pribjegne pobuni protiv tiranije i ugnjetavanja,

BUDUĆI da je bitno da se unapređuje razvoj prijateljskih odnosa između naroda,

BUDUĆI da su narodi Ujedinjenih nacija ponovo potvrdili u Povelji svoju vjeru u osnovna prava čovjeka, u dostojanstvo i vrijednost čovjekove osobe i u ravnopravnost muškaraca i žena i posto su odlučili da unapređuju društveni napredak i bolji životni standard u široj slobodi,

BUDUĆI da su se Države Članice obavezale da, u suradnji s Ujedinjenim nacijama, postignu unapređenje općeg poštivanja čovjekovih prava i osnovnih sloboda i njihovo održavanje,

BUDUĆI da je zajedničko razumijevanje tih prava i sloboda od najveće važnosti za puno ostvarenje te obaveze,

GENERALNA SKUPSTINA PROGLAŠAVA

OVU OPĆU DEKLARACIJU O PRAVIMA ČOVJEKA kao zajedničko mjerilo postizanja za sve narode i sve države radi toga da bi svaki organ društva, imajući Deklaraciju stalno na umu, težili da učenjem i odgojem doprinesu poštivanju ovih prava i sloboda i da bi progresivnim nacionalnim i međunarodnim mjerama osigurali njihovo opće i djelotvorno priznavanje i održavanje, kako među narodima samih Država Članica, tako i među narodima onih područja koja su pod njihovom ingerencijom.



Član 1.
Sva ljudska bića rađaju se slobodna i jednaka u dostojanstvu i pravima. Ona su obdarena razumom i sviješću i treba da jedno prema drugome postupaju u duhu bratstva.

Član 2.
Svakome su dostupna sva prava i slobode navedene u ovoj Deklaraciji bez razlike bilo koje vrste, kao sto su rasa, boja, spol, jezik, vjera, političko ili drugo mišljenje, narodonosno ili društveno porijeklo, imovina, rođenje ili drugi pravni položaj. Nadalje, ne smije se činiti bilo kakva razlika na osnovu političkog, pravnog ili međunarodnog položaja zemlje ili područja kojima neka osoba pripada, bilo da je ovo područje nezavisno, pod starateljstvom, nesamoupravno, ili da se nalazi ma pod kojim drugim ograničenjima suverenosti.

Član 3.
Svako ima pravo na život, slobodu i osobnu sigurnost.

Član 4.
Niko ne smije biti držan u ropstvu ili ropskom odnosu; ropstvo i trgovina robljem zabranjuje se u svim njihovim oblicima.

Član 5.
Niko ne smije biti podvrgnut mučenju ili okrutnom, nečovječnom ili ponižavajućem postupku ili kažnjavanju.

Član 6.
Svako ima pravo da se svagdje pred zakonom priznaje kao osoba.

Član 7.
Svi su pred zakonom jednaki i imaju pravo, bez ikakve diskriminacije, na jednaku zaštitu zakona. Svi imaju pravo na jednaku zaštitu protiv bilo kakve diskriminacije kojom se krši ova Deklaracija i protiv svakog podsticanja na takvu diskriminaciju.

Član 8.
Svako ima pravo na djelotvorna pravna sredstva putem nadležnih nacionalnih sudova zbog djela kojima se krše osnovna prava koja su mu dodijeljena u Ustavu ili zakonu.

Član 9.
Niko ne smije biti podvrgnut samovoljnom hapšenju, zatvoru ili izgonu.

Član 10.
Svako ima pravo da ga u punoj jednakosti pošteno i javno sasluša nezavisan i nepristran sud radi utvrđivanja njegovih prava i obaveza i bilo kakve krivične optužbe protiv njega.

Član 11.
Svako ko je optužen za krivično djelo ima pravo da se smatra nevinim dok se na temelju zakona krivnja ne dokaže na javnom pretresu na kojem je imao sva jamstva potrebna za svoju odbranu,
Niko se ne smije smatrati krivim za krivično djelo na temelju bilo kakvog čina ili propusta koji nisu predstavljali krivično djelo u smislu nacionalnog ili međunarodnog prava u vrijeme kada su oni bili počinjeni. Isto tako ne smije se izricati teža kazna od one koja se mogla primjeniti kada je krivično djelo počinjeno.
Član 12.
Niko na smije biti izvrgnut samovoljnom miješanju u njegov privatni zivot, obitelj, dom ili prepisku, niti napadajima na njegovu čast i ugled. Svako ima pravo na zaštitu zakona protiv ovakvom miješanju ili napadu.

Član 13.
Svako ima pravo na slobodu kretanja i stanovanja unutar granice svake države.
Svako ima pravo da napusti bilo koju zemlju, uključujući svoju vlastitu i da se vrati u svoju zemlju.
Član 14.
Svako ima pravo da traži i uživa u drugim zemljama utočište pred progonima.
Na to se pravno ne može pozivati u slučaju progona koji su zaista izazvani nepolitičkim zločinima ili djelima protivnim ciljevima i načelima Ujedinjenih nacija.
Član 15.
Svako ima pravo na državljanstvo.
Niko ne smije samovoljno biti lišen svojeg državljanstva niti mu se smije odreći pravo da promijeni svoje državljanstvo.
Član 16.
Punoljetni muškarci i žene bez ikakvih ograničenja u pogledu rase, državljanstva ili vjere, imaju pravo da sklope brak i da osnuju obitelj. Oni su ravnopravni prilikom sklapanja braka, za vrijeme njegova trajanja i prilikom njegova razvoda.
Brak se sklapa samo uz slobodan i potpun pristanak onih koji namjeravaju stupiti u brak.
Obitelj je prirodna i osnovna društvena jedinica i ima pravo na zaštitu društva i države.
Član 17.
Svako ima pravo da sam posjeduje imovinu, a isto tako da je posjeduje u zajednici s drugima.
Niko ne smije samovoljno biti lišen svoje imovine.
Član 18.
Svako ima pravo na slobodu misli, savjesti i vjere; to pravo uključuje slobodu promijeniti svoju vjeru ili vjerovanje i slobodu da se, bilo pojedinačno ili u zajednici s drugima, javno ili privatno, ispoljava vjera ili vjerovanje učenjem, vršenjem, obredima i održavanjem.

Član 19.
Svako ima pravo na slobodu mišljenja i izražavanja; ovo pravo uključuje slobodu mišljenja bez tuđeg mišljenja a isto tako i traženje, primanje i saopćavanje obavještenja i ideja bilo kojim sredstvima i bez obzira na granice.

Član 20.
Svako ima pravo na slobodu mirnog okupljanja i udruživanja.
Niko ne može biti primoran da pripada nekom udruženju.
Član 21.
Svako ima pravo da sudjeluje u upravi svoje zemlje, neposredno ili preko slobodno izabranih predstavnika.
Svako ima pravo na jednak pristup javnim službama u svojoj zemlji.
Volja naroda treba da bude osnova vladine vlasti; ta volja treba da se izražava u povremenim i istinskim izborima, koji treba da se provode općim i jednakim pravom glasa, tajnim glasanjem ili odgovarajućim postupcima slobodnog glasanja.
Član 22.
Svako, kao član drustva, ima pravo na socijalno osiguranje i pravo da ostvaruje ekonomska, socijalna i kulturna prava neophodna za svoje dostojanstvo i za razvoj svoje ličnosti putem državne pomoći i međunarodne suradnje a u skladu s organizacijom i sredstvima svake države.

Član 23.
Svako ima pravo na rad, na slobodan izbor zaposlenja, na pravične i povoljne uvjete rada i na zaštitu od nezaposlenosti.
Svako, bez razlike, ima pravo na jednaku plaću za jednaki rad.
Svako ko radi ima pravo na pravičnu i povoljnu naplatu koja njemu i njegovoj obitelji osigurava čovjeka dostojni opstanak i koja se, po potrebi, dopunjuje drugim sredstvima socijalne zaštite.
Svako ima pravo da radi zaštite svojih interesa obrazuje sindikate i da stupa u njih.
Član 24.
Svako ima pravo na odmor i dokolicu uključujući razumno ograničenje radnih sati i periodične plaćene praznike.

Član 25.
Svako ima pravo na životni standard koji odgovara zdravlju i dobrobiti njega samoga i njegove obitelji, uključujući hranu, odjeću, stan i liječničku njegu i potrebne socijalne usluge, kao i pravo na osiguranje za slučaj nezaposlenosti, bolesti, nesposobnosti, udovišta, starosti ili drugog pomanjkanja sredstava za život u prilikama koje su izvan njegove moći.
Majka i dijete imaju pravo na naročitu brigu i pomoć. Sva djeca, bilo rođena u braku ili izvan njega, treba da uživaju istu socijalnu zaštitu.
Član 26.
Svako ima pravo na obrazovanje. Obrazovanje treba da bude besplatno, bar u osnovnim i nižim stupnjevima. Osnovno obrazovanje treba da bude obavezno. Tehničko i stručno obrazovanje treba da bude općenito pristupačno, a i više obrazovanje treba takođe da bude svima pristupačno na temelju sposobnosti.
Obrazovanje treba da bude usmjereno na puni razvitak ljudske ličnosti i na učvršćavanje poštivanja čovjekovih prava i osnovnih sloboda. Ono treba da unapređuje razumijevanje, snošljivost i prijateljstvo medju svim narodima, rasnim i vjerskim skupinama, i treba da unapređuje djelatnost Ujedinjenih nacija na održavanju mira.
Roditelji imaju prvenstveno pravo da biraju vstu obrazovanja za svoju djecu.
Član 27.
Svako ima pravo da slobodno sudjeluje u kulturnom životu zajednice, da uživa u umjetnosti i da učestvuje u znanstvenom napretku i u njegovim koristima.
Svako ima pravo na zaštitu moralnih i materijalnih interesa koji proistiću ma od kojeg znanstvenog, književnog ili umjetničkog proizvoda kojemu je autor.
Član 28.
Svako ima pravo na društveni i međunarodni poredak u kojem prava i slobode izložene u ovoj Deklaraciji mogu biti potpuno ostvarene.

Član 29.
Svako ima obaveze prema zajednici iz koje je jedino moguće slobodno i puno razvijanje njegove ličnosti.
U vršenju svojih prava i sloboda svatko treba da bude podvrgnut samo onim ograničenjima koja su određena zakonom isključivo u cilju osiguranja dužnog priznanja i poštivanja prava i sloboda drugih i u cilju zadovoljenja pravičnih zahtjeva morala, javnog poretka i općeg blagostanja u demokratskom društvu.
Ta prava i slobode ni u kojem slučaju ne mogu se primjenjivati protivno ciljevima i načelima Ujedinjenih nacija.
Član 30.
Ništa se u ovoj Deklaraciji ne može tumačiti kao pravo ma koje države, skupine ili osobe da sudjeluje u bilo kojoj djelatnosti ili da vrši bilo kakvu djelatnost usmjerenu na uništavanje bilo kojih ovdje izloženih prava i sloboda.



TEXT

is(Text::Guess::Language->guess($text),'bs','is bs');

done_testing;
