
package Paws::IAM::AddClientIDToOpenIDConnectProvider;
  use Moose;
  has ClientID => (is => 'ro', isa => 'Str', required => 1);
  has OpenIDConnectProviderArn => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'AddClientIDToOpenIDConnectProvider');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::API::Response');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::IAM::AddClientIDToOpenIDConnectProvider - Arguments for method AddClientIDToOpenIDConnectProvider on L<Paws::IAM>

=head1 DESCRIPTION

This class represents the parameters used for calling the method AddClientIDToOpenIDConnectProvider on the
L<AWS Identity and Access Management|Paws::IAM> service. Use the attributes of this class
as arguments to method AddClientIDToOpenIDConnectProvider.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to AddClientIDToOpenIDConnectProvider.

=head1 SYNOPSIS

    my $iam = Paws->service('IAM');
    # To add a client ID (audience) to an Open-ID Connect (OIDC) provider
    # The following add-client-id-to-open-id-connect-provider command adds the
    # client ID my-application-ID to the OIDC provider named server.example.com:
    $iam->AddClientIDToOpenIDConnectProvider(
      'ClientID'                 => 'my-application-ID',
      'OpenIDConnectProviderArn' =>
        'arn:aws:iam::123456789012:oidc-provider/server.example.com'
    );


Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/iam/AddClientIDToOpenIDConnectProvider>

=head1 ATTRIBUTES


=head2 B<REQUIRED> ClientID => Str

The client ID (also known as audience) to add to the IAM OpenID Connect
provider resource.



=head2 B<REQUIRED> OpenIDConnectProviderArn => Str

The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC)
provider resource to add the client ID to. You can get a list of OIDC
provider ARNs by using the ListOpenIDConnectProviders operation.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method AddClientIDToOpenIDConnectProvider in L<Paws::IAM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

