/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.views;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.util.JSONUtils;
import org.couchbase.mock.memcached.DataStore;
import org.couchbase.mock.views.Configuration;
import org.couchbase.mock.views.Mapper;
import org.couchbase.mock.views.Reducer;
import sun.org.mozilla.javascript.NativeArray;
import sun.org.mozilla.javascript.Scriptable;
import sun.org.mozilla.javascript.ScriptableObject;

public class View {
    public static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
    private final String name;
    private final String mapSource;
    private final String reduceSource;
    private final ScriptEngine jsEngine;
    private final Mapper mapper;
    private Reducer reducer;

    public View(String name, String map) throws ScriptException {
        this(name, map, null);
    }

    public View(String name, String map, String reduce) throws ScriptException {
        this.name = name;
        this.mapSource = map;
        this.reduceSource = reduce;
        this.jsEngine = new ScriptEngineManager().getEngineByName("javascript");
        this.jsEngine.eval("emit = function(key, value) { result.push([key, value]) }");
        this.jsEngine.eval("sum = function(values) { var sum = 0; for (var i = 0; i < values.length; ++i) { sum += values[i]; }; return sum; }");
        this.mapper = new Mapper(this.jsEngine, this.mapSource);
        if (this.reduceSource != null) {
            this.reducer = new Reducer(this.jsEngine, this.reduceSource);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getMapSource() {
        return this.mapSource;
    }

    public String getReduceSource() {
        return this.reduceSource;
    }

    public HashMap execute(DataStore store) {
        return this.execute(store, null);
    }

    public HashMap execute(DataStore store, Configuration config) {
        if (config == null) {
            config = new Configuration();
        }
        ArrayList<HashMap> rows = this.mapper.execute(store, config);
        if (config.reduce() && this.reducer != null) {
            try {
                rows = this.reducer.execute(rows, config);
            }
            catch (ScriptException ex) {
                Logger.getLogger(View.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Collections.sort(rows, new RowComparator(config));
        int totalRows = rows.size();
        int offset = 0;
        int end = rows.size();
        if (config.hasRange()) {
            Object startKey = View.parseJSON(config.getStartKey());
            Object startKeyDocId = View.parseJSON(config.getStartKeyDocId());
            Object endKey = View.parseJSON(config.getEndKey());
            Object endKeyDocId = View.parseJSON(config.getEndKeyDocId());
            if (config.isDescending()) {
                Object tmp = startKey;
                startKey = endKey;
                endKey = tmp;
                tmp = startKeyDocId;
                startKeyDocId = endKeyDocId;
                endKeyDocId = tmp;
            }
            for (int i = 0; i < rows.size(); ++i) {
                HashMap row = (HashMap)rows.get(i);
                Object key = row.get("key");
                Object id = row.get("id");
                if (key.equals(startKey) && offset == 0 && (startKeyDocId == null || startKeyDocId != null && id.equals(startKeyDocId))) {
                    offset = i;
                }
                if (!key.equals(endKey) || endKeyDocId != null && (endKeyDocId == null || !id.equals(endKeyDocId))) continue;
                if (!config.isInclusiveEnd()) {
                    end = i - 1;
                    break;
                }
                end = i;
            }
            while (end < rows.size() - 1) {
                rows.remove(rows.size() - 1);
            }
        }
        if ((offset += config.getSkip()) > rows.size()) {
            offset = rows.size();
        }
        for (int i = 0; i < offset; ++i) {
            rows.remove(0);
        }
        if (config.getLimit() != null) {
            while (rows.size() > config.getLimit()) {
                rows.remove(rows.size() - 1);
            }
        }
        ArrayList<Object> filter = new ArrayList<Object>();
        if (config.getKey() != null) {
            filter.add(config.getKey());
        }
        if (config.getKeys() != null) {
            filter.addAll(config.getKeys());
        }
        if (!filter.isEmpty()) {
            for (int i = 0; i < filter.size(); ++i) {
                try {
                    filter.set(i, JSONSerializer.toJSON(filter.get(i)));
                    continue;
                }
                catch (JSONException ex) {
                    // empty catch block
                }
            }
            ArrayList<HashMap> filtered = new ArrayList<HashMap>();
            for (HashMap row : rows) {
                if (!filter.contains(row.get("key"))) continue;
                filtered.add(row);
            }
            rows = filtered;
        }
        HashMap<String, Serializable> response = new HashMap<String, Serializable>();
        response.put("total_rows", Integer.valueOf(totalRows));
        response.put("offset", Integer.valueOf(offset));
        response.put("rows", rows);
        return response;
    }

    public static Object fromNativeObject(Object object) {
        if (object instanceof NativeArray) {
            NativeArray array = (NativeArray)object;
            int length = (int)array.getLength();
            ArrayList<Object> json = new ArrayList<Object>();
            for (int i = 0; i < length; ++i) {
                json.add(View.fromNativeObject(ScriptableObject.getProperty((Scriptable)array, (int)i)));
            }
            return json;
        }
        if (object instanceof ScriptableObject) {
            Object[] ids;
            ScriptableObject scriptable = (ScriptableObject)object;
            HashMap<String, Object> json = new HashMap<String, Object>();
            for (Object id : ids = scriptable.getAllIds()) {
                String key = id.toString();
                Object property = ScriptableObject.getProperty((Scriptable)scriptable, (String)key);
                Object value = null;
                if (property instanceof Scriptable && ((Scriptable)property).getClassName().equals("Date")) {
                    Object time = ScriptableObject.callMethod((Scriptable)scriptable, (String)"getTime", null);
                    if (time instanceof Number) {
                        value = DATE_FORMAT.format(new Date(((Number)time).longValue()));
                    }
                } else {
                    value = View.fromNativeObject(property);
                }
                json.put(key, value);
            }
            return json;
        }
        if (object instanceof Integer) {
            return ((Number)object).longValue();
        }
        if (object instanceof Double || object instanceof Float) {
            Double d = ((Number)object).doubleValue();
            if (d % 1.0 == 0.0) {
                return d.longValue();
            }
            return object;
        }
        return object;
    }

    public static Object parseJSON(Object object) {
        if (object == null || JSONUtils.isNumber(object) || JSONUtils.isBoolean(object)) {
            return object;
        }
        try {
            return JSONSerializer.toJSON(object);
        }
        catch (JSONException e1) {
            try {
                return Long.parseLong((String)object);
            }
            catch (NumberFormatException e2) {
                try {
                    return Double.parseDouble((String)object);
                }
                catch (NumberFormatException e3) {
                    return object;
                }
            }
        }
    }

    public static class RowComparator
    implements Comparator<HashMap> {
        private Configuration config;

        public RowComparator(Configuration config) {
            this.config = config;
        }

        @Override
        public int compare(HashMap o1, HashMap o2) {
            int ret;
            Object key1 = View.parseJSON(o1.get("key"));
            Object key2 = View.parseJSON(o2.get("key"));
            Object id1 = View.parseJSON(o1.get("id"));
            Object id2 = View.parseJSON(o2.get("id"));
            if (this.config.isDescending()) {
                ret = RowComparator.jsonCompareTo(key2, key1);
                if (ret == 0) {
                    ret = RowComparator.jsonCompareTo(id2, id1);
                }
            } else {
                ret = RowComparator.jsonCompareTo(key1, key2);
                if (ret == 0) {
                    ret = RowComparator.jsonCompareTo(id1, id2);
                }
            }
            return ret;
        }

        public static int jsonCompareTo(Object a, Object b) {
            if (a instanceof JSONObject) {
                if (b instanceof JSONObject) {
                    int result;
                    JSONObject ao = (JSONObject)a;
                    JSONObject bo = (JSONObject)b;
                    Set as = ao.keySet();
                    Iterator ai = as.iterator();
                    do {
                        if (!ai.hasNext()) {
                            if (bo.isEmpty()) {
                                return 0;
                            }
                            return -1;
                        }
                        if (bo.isEmpty()) {
                            return 1;
                        }
                        Object key = ai.next();
                        if (!bo.containsKey(key)) {
                            return 1;
                        }
                        result = RowComparator.jsonCompareTo(ao.get(key), bo.get(key));
                        bo.remove(key);
                    } while (result == 0);
                    return result;
                }
                return -1;
            }
            if (b instanceof JSONObject) {
                return 1;
            }
            if (a instanceof JSONArray) {
                if (b instanceof JSONArray) {
                    int result;
                    Iterator ai = ((JSONArray)a).iterator();
                    Iterator bi = ((JSONArray)b).iterator();
                    do {
                        if (!ai.hasNext()) {
                            if (!bi.hasNext()) {
                                return 0;
                            }
                            return -1;
                        }
                        if (bi.hasNext()) continue;
                        return 1;
                    } while ((result = RowComparator.jsonCompareTo(ai.next(), bi.next())) == 0);
                    return result;
                }
                return -1;
            }
            if (b instanceof JSONArray) {
                return 1;
            }
            if (JSONUtils.isNumber(a) && JSONUtils.isNumber(b)) {
                return (int)Math.floor(((Number)a).doubleValue() - ((Number)b).doubleValue());
            }
            Comparable ac = (Comparable)a;
            Comparable bc = (Comparable)b;
            return ac.compareTo(bc);
        }
    }

    public class CompilationError
    extends Exception {
    }
}

