package Perl::Types::RefactorNamesMap;
use strict; use warnings;
our $refactor_names_map = {
  'cpp' => {
             'AVRVHVRV' => 'HVRVAVRV',
             'AVRVHVRVHE' => 'HVRVAVRVHE',
             'AVRVHVRVHVRV' => 'HVRVHVRVAVRV',
             'EIVAVRV00' => 'EAVRVIV00',
             'EIVAVRV01' => 'EAVRVIV01',
             'EIVAVRV02' => 'EAVRVIV02',
             'EIVAVRV03' => 'EAVRVIV03',
             'EIVAVRVAVRV00' => 'EAVRVAVRVIV00',
             'EIVAVRVAVRV01' => 'EAVRVAVRVIV01',
             'EIVAVRVAVRV02' => 'EAVRVAVRVIV02',
             'EIVAVRVAVRV03' => 'EAVRVAVRVIV03',
             'EIVAVRVAVRV04' => 'EAVRVAVRVIV04',
             'EIVAVRVAVRV05' => 'EAVRVAVRVIV05',
             'EIVAVRVHE00' => 'EHVRVAVRVIVHE00',
             'EIVAVRVHVRV00' => 'EHVRVAVRVIV00',
             'EIVAVRVHVRV01' => 'EHVRVAVRVIV01',
             'EIVAVRVHVRV02' => 'EHVRVAVRVIV02',
             'EIVAVRVHVRV03' => 'EHVRVAVRVIV03',
             'EIVAVRVHVRV04' => 'EHVRVAVRVIV04',
             'EIVAVRVHVRV05' => 'EHVRVAVRVIV05',
             'EIVAVRVHVRVHE00' => 'EHVRVHVRVAVRVIVHE00',
             'EIVAVRVHVRVHE01' => 'EHVRVHVRVAVRVIVHE01',
             'EIVAVRVHVRVHVRV00' => 'EHVRVHVRVAVRVIV00',
             'EIVAVRVHVRVHVRV01' => 'EHVRVHVRVAVRVIV01',
             'EIVAVRVHVRVHVRV02' => 'EHVRVHVRVAVRVIV02',
             'EIVAVRVHVRVHVRV03' => 'EHVRVHVRVAVRVIV03',
             'EIVAVRVHVRVHVRV04' => 'EHVRVHVRVAVRVIV04',
             'EIVAVRVHVRVHVRV05' => 'EHVRVHVRVAVRVIV05',
             'EIVAVRVHVRVHVRV06' => 'EHVRVHVRVAVRVIV06',
             'EIVAVRVHVRVHVRV07' => 'EHVRVHVRVAVRVIV07',
             'EIVHVRV00' => 'EHVRVIV00',
             'EIVHVRV01' => 'EHVRVIV01',
             'EIVHVRV02' => 'EHVRVIV02',
             'EIVHVRV03' => 'EHVRVIV03',
             'ENVAV' => 'EAVNV',
             'ENVAVRV00' => 'EAVRVNV00',
             'ENVAVRV01' => 'EAVRVNV01',
             'ENVAVRV02' => 'EAVRVNV02',
             'ENVAVRV03' => 'EAVRVNV03',
             'ENVAVRVAVRV00' => 'EAVRVAVRVNV00',
             'ENVAVRVAVRV01' => 'EAVRVAVRVNV01',
             'ENVAVRVAVRV02' => 'EAVRVAVRVNV02',
             'ENVAVRVAVRV03' => 'EAVRVAVRVNV03',
             'ENVAVRVAVRV04' => 'EAVRVAVRVNV04',
             'ENVAVRVAVRV05' => 'EAVRVAVRVNV05',
             'ENVAVRVHVRV00' => 'EHVRVAVRVNV00',
             'ENVAVRVHVRV01' => 'EHVRVAVRVNV01',
             'ENVAVRVHVRV02' => 'EHVRVAVRVNV02',
             'ENVAVRVHVRV03' => 'EHVRVAVRVNV03',
             'ENVAVRVHVRV04' => 'EHVRVAVRVNV04',
             'ENVAVRVHVRV05' => 'EHVRVAVRVNV05',
             'ENVAVRVHVRVHE00' => 'EHVRVHVRVAVRVNVHE00',
             'ENVAVRVHVRVHE01' => 'EHVRVHVRVAVRVNVHE01',
             'ENVAVRVHVRVHVRV00' => 'EHVRVHVRVAVRVNV00',
             'ENVAVRVHVRVHVRV01' => 'EHVRVHVRVAVRVNV01',
             'ENVAVRVHVRVHVRV02' => 'EHVRVHVRVAVRVNV02',
             'ENVAVRVHVRVHVRV03' => 'EHVRVHVRVAVRVNV03',
             'ENVAVRVHVRVHVRV04' => 'EHVRVHVRVAVRVNV04',
             'ENVAVRVHVRVHVRV05' => 'EHVRVHVRVAVRVNV05',
             'ENVAVRVHVRVHVRV06' => 'EHVRVHVRVAVRVNV06',
             'ENVAVRVHVRVHVRV07' => 'EHVRVHVRVAVRVNV07',
             'ENVHVRV00' => 'EHVRVNV00',
             'ENVHVRV01' => 'EHVRVNV01',
             'ENVHVRV02' => 'EHVRVNV02',
             'ENVHVRV03' => 'EHVRVNV03',
             'EPVAV' => 'EAVPV',
             'EPVAVRV00' => 'EAVRVPV00',
             'EPVAVRV01' => 'EAVRVPV01',
             'EPVAVRV02' => 'EAVRVPV02',
             'EPVAVRV03' => 'EAVRVPV03',
             'EPVAVRVAVRV00' => 'EAVRVAVRVPV00',
             'EPVAVRVAVRV01' => 'EAVRVAVRVPV01',
             'EPVAVRVAVRV02' => 'EAVRVAVRVPV02',
             'EPVAVRVAVRV03' => 'EAVRVAVRVPV03',
             'EPVAVRVAVRV04' => 'EAVRVAVRVPV04',
             'EPVAVRVAVRV05' => 'EAVRVAVRVPV05',
             'EPVAVRVHVRV00' => 'EHVRVAVRVPV00',
             'EPVAVRVHVRV01' => 'EHVRVAVRVPV01',
             'EPVAVRVHVRV02' => 'EHVRVAVRVPV02',
             'EPVAVRVHVRV03' => 'EHVRVAVRVPV03',
             'EPVAVRVHVRV04' => 'EHVRVAVRVPV04',
             'EPVAVRVHVRV05' => 'EHVRVAVRVPV05',
             'EPVAVRVHVRVHE00' => 'EHVRVHVRVAVRVPVHE00',
             'EPVAVRVHVRVHE01' => 'EHVRVHVRVAVRVPVHE01',
             'EPVAVRVHVRVHVRV00' => 'EHVRVHVRVAVRVPV00',
             'EPVAVRVHVRVHVRV01' => 'EHVRVHVRVAVRVPV01',
             'EPVAVRVHVRVHVRV02' => 'EHVRVHVRVAVRVPV02',
             'EPVAVRVHVRVHVRV03' => 'EHVRVHVRVAVRVPV03',
             'EPVAVRVHVRVHVRV04' => 'EHVRVHVRVAVRVPV04',
             'EPVAVRVHVRVHVRV05' => 'EHVRVHVRVAVRVPV05',
             'EPVAVRVHVRVHVRV06' => 'EHVRVHVRVAVRVPV06',
             'EPVAVRVHVRVHVRV07' => 'EHVRVHVRVAVRVPV07',
             'EPVHVRV00' => 'EHVRVPV00',
             'EPVHVRV01' => 'EHVRVPV01',
             'EPVHVRV02' => 'EHVRVPV02',
             'EPVHVRV03' => 'EHVRVPV03',
             'XS_pack_integer_arrayref' => 'XS_pack_arrayref_integer',
             'XS_pack_integer_arrayref_arrayref' => 'XS_pack_arrayref_arrayref_integer',
             'XS_pack_integer_arrayref_hashref' => 'XS_pack_hashref_arrayref_integer',
             'XS_pack_integer_arrayref_hashref_hashref' => 'XS_pack_hashref_hashref_arrayref_integer',
             'XS_pack_integer_hashref' => 'XS_pack_hashref_integer',
             'XS_pack_number_arrayref' => 'XS_pack_arrayref_number',
             'XS_pack_number_arrayref_arrayref' => 'XS_pack_arrayref_arrayref_number',
             'XS_pack_number_arrayref_hashref' => 'XS_pack_hashref_arrayref_number',
             'XS_pack_number_arrayref_hashref_hashref' => 'XS_pack_hashref_hashref_arrayref_number',
             'XS_pack_number_hashref' => 'XS_pack_hashref_number',
             'XS_pack_string_arrayref' => 'XS_pack_arrayref_string',
             'XS_pack_string_arrayref_arrayref' => 'XS_pack_arrayref_arrayref_string',
             'XS_pack_string_arrayref_hashref' => 'XS_pack_hashref_arrayref_string',
             'XS_pack_string_arrayref_hashref_hashref' => 'XS_pack_hashref_hashref_arrayref_string',
             'XS_pack_string_hashref' => 'XS_pack_hashref_string',
             'XS_unpack_TYPE_arrayref_hashref' => 'XS_unpack_hashref_arrayref_TYPE',
             'XS_unpack_TYPE_arrayref_hashref_hashref' => 'XS_unpack_hashref_hashref_arrayref_TYPE',
             'XS_unpack_integer_arrayref' => 'XS_unpack_arrayref_integer',
             'XS_unpack_integer_arrayref_arrayref' => 'XS_unpack_arrayref_arrayref_integer',
             'XS_unpack_integer_arrayref_hashref' => 'XS_unpack_hashref_arrayref_integer',
             'XS_unpack_integer_arrayref_hashref_hashref' => 'XS_unpack_hashref_hashref_arrayref_integer',
             'XS_unpack_integer_hashref' => 'XS_unpack_hashref_integer',
             'XS_unpack_integer_hashref_arrayref' => 'XS_unpack_arrayref_hashref_integer',
             'XS_unpack_number_arrayref' => 'XS_unpack_arrayref_number',
             'XS_unpack_number_arrayref_arrayref' => 'XS_unpack_arrayref_arrayref_number',
             'XS_unpack_number_arrayref_hashref' => 'XS_unpack_hashref_arrayref_number',
             'XS_unpack_number_arrayref_hashref_hashref' => 'XS_unpack_hashref_hashref_arrayref_number',
             'XS_unpack_number_hashref' => 'XS_unpack_hashref_number',
             'XS_unpack_number_hashref_arrayref' => 'XS_unpack_arrayref_hashref_number',
             'XS_unpack_string_arrayref' => 'XS_unpack_arrayref_string',
             'XS_unpack_string_arrayref_arrayref' => 'XS_unpack_arrayref_arrayref_string',
             'XS_unpack_string_arrayref_hashref' => 'XS_unpack_hashref_arrayref_string',
             'XS_unpack_string_arrayref_hashref_hashref' => 'XS_unpack_hashref_hashref_arrayref_string',
             'XS_unpack_string_hashref' => 'XS_unpack_hashref_string',
             'XS_unpack_string_hashref_arrayref' => 'XS_unpack_arrayref_hashref_string',
             '_arrayref_hash_' => '_hash_arrayref_',
             '_arrayref_hashentry' => 'arrayref_TYPE_hashentry',
             '_arrayref_hashref' => 'hashref_arrayref_',
             '_arrayref_hashref_hash_' => '_hash_hashref_arrayref_',
             '_arrayref_hashref_hashentry' => 'hashref_arrayref_TYPE__hashentry',
             '_arrayref_hashref_hashref' => 'hashref_hashref_arrayref_',
             'gsl_matrix_to_number_arrayref' => 'gsl_matrix_to_arrayref_number',
             'gsl_matrix_to_number_arrayref_arrayref' => 'gsl_matrix_to_arrayref_arrayref_number',
             'input_av_element' => 'input_av__element',
             'input_av_element_string' => 'input_av__element_string',
             'input_av_element_string_pos' => 'input_av__element_string_pos',
             'input_av_length' => 'input_av__length',
             'input_avref_av' => 'input_av_avref',
             'input_avref_av_element' => 'input_av_avref__element',
             'input_avref_av_length' => 'input_av_avref__length',
             'input_avref_hv' => 'input_hv_avref',
             'input_avref_hv_entry' => 'input_hv_avref__entry',
             'input_avref_hv_entry_key' => 'input_hv_avref__entry_key',
             'input_avref_hv_entry_key_string' => 'input_hv_avref__entry_key_string',
             'input_avref_hv_entry_value' => 'input_hv_avref__entry_value',
             'input_avref_hv_num_keys' => 'input_hv_avref__num_keys',
             'input_avref_hvref' => 'input_hvref_avref',
             'input_avref_hvref_hv' => 'input_hv_hvref_avref',
             'input_avref_hvref_hv_entry' => 'input_hv_hvref_avref__entry',
             'input_avref_hvref_hv_entry_key' => 'input_hv_hvref_avref__entry_key',
             'input_avref_hvref_hv_entry_value' => 'input_hv_hvref_avref__entry_value',
             'input_avref_hvref_hv_num_keys' => 'input_hv_hvref_avref__num_keys',
             'input_avref_hvref_hvref' => 'input_hvref_hvref_avref',
             'input_hv_entry' => 'input_hv__entry',
             'input_hv_entry_key' => 'input_hv__entry_key',
             'input_hv_entry_key_string' => 'input_hv__entry_key_string',
             'input_hv_entry_value' => 'input_hv__entry_value',
             'input_hv_entry_value_string' => 'input_hv__entry_value_string',
             'input_hv_num_keys' => 'input_hv__num_keys',
             'input_number_arrayref' => 'input_arrayref_number',
             'input_unordered_map_num_keys' => 'input_umap__num_keys',
             'input_vector_element' => 'input_vector__element',
             'input_vector_element_pos' => 'input_vector__element_pos',
             'input_vector_length' => 'input_vector__length',
             'input_vector_unordered_map' => 'input_umap_vector',
             'input_vector_unordered_map_num_keys' => 'input_umap_vector__num_keys',
             'input_vector_unordered_map_unordered_map' => 'input_umap_umap_vector',
             'input_vector_unordered_map_unordered_map_num_keys' => 'input_umap_umap_vector__num_keys',
             'input_vector_vector_length' => 'input_vector_vector__length',
             'integer_arrayref' => 'arrayref_integer',
             'integer_arrayref_CHECK' => 'arrayref_integer_CHECK',
             'integer_arrayref_CHECKTRACE' => 'arrayref_integer_CHECKTRACE',
             'integer_arrayref_arrayref' => 'arrayref_arrayref_integer',
             'integer_arrayref_arrayref_CHECK' => 'arrayref_arrayref_integer_CHECK',
             'integer_arrayref_arrayref_CHECKTRACE' => 'arrayref_arrayref_integer_CHECKTRACE',
             'integer_arrayref_hashref' => 'hashref_arrayref_integer',
             'integer_arrayref_hashref_CHECK' => 'hashref_arrayref_integer_CHECK',
             'integer_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_integer_CHECKTRACE',
             'integer_arrayref_hashref_const_iterator' => 'hashref_arrayref_integer_const_iterator',
             'integer_arrayref_hashref_hashref' => 'hashref_hashref_arrayref_integer',
             'integer_arrayref_hashref_hashref_CHECK' => 'hashref_hashref_arrayref_integer_CHECK',
             'integer_arrayref_hashref_hashref_CHECKTRACE' => 'hashref_hashref_arrayref_integer_CHECKTRACE',
             'integer_arrayref_hashref_hashref_const_iterator' => 'hashref_hashref_arrayref_integer_const_iterator',
             'integer_arrayref_hashref_to_string' => 'hashref_arrayref_integer_to_string',
             'integer_arrayref_hashref_to_string_compact' => 'hashref_arrayref_integer_to_string_compact',
             'integer_arrayref_hashref_to_string_expand' => 'hashref_arrayref_integer_to_string_expand',
             'integer_arrayref_hashref_to_string_format' => 'hashref_arrayref_integer_to_string_format',
             'integer_arrayref_hashref_to_string_pretty' => 'hashref_arrayref_integer_to_string_pretty',
             'integer_arrayref_hashref_typetest0' => 'hashref_arrayref_integer_typetest0',
             'integer_arrayref_hashref_typetest1' => 'hashref_arrayref_integer_typetest1',
             'integer_arrayref_to_string' => 'arrayref_integer_to_string',
             'integer_arrayref_to_string_compact' => 'arrayref_integer_to_string_compact',
             'integer_arrayref_to_string_expand' => 'arrayref_integer_to_string_expand',
             'integer_arrayref_to_string_format' => 'arrayref_integer_to_string_format',
             'integer_arrayref_to_string_pretty' => 'arrayref_integer_to_string_pretty',
             'integer_arrayref_typetest0' => 'arrayref_integer_typetest0',
             'integer_arrayref_typetest1' => 'arrayref_integer_typetest1',
             'integer_hashref' => 'hashref_integer',
             'integer_hashref_CHECK' => 'hashref_integer_CHECK',
             'integer_hashref_CHECKTRACE' => 'hashref_integer_CHECKTRACE',
             'integer_hashref_const_iterator' => 'hashref_integer_const_iterator',
             'integer_hashref_to_string' => 'hashref_integer_to_string',
             'integer_hashref_to_string_compact' => 'hashref_integer_to_string_compact',
             'integer_hashref_to_string_expand' => 'hashref_integer_to_string_expand',
             'integer_hashref_to_string_format' => 'hashref_integer_to_string_format',
             'integer_hashref_to_string_pretty' => 'hashref_integer_to_string_pretty',
             'integer_hashref_typetest0' => 'hashref_integer_typetest0',
             'integer_hashref_typetest1' => 'hashref_integer_typetest1',
             'lucky_integer_array' => 'lucky_array_integer',
             'lucky_integer_arrayref' => 'lucky_arrayref_integer',
             'lucky_integer_arrayref_entry' => 'lucky_arrayref_integer__entry',
             'lucky_integer_arrayref_key' => 'lucky_arrayref_integer__key',
             'lucky_integer_arrayref_value' => 'lucky_arrayref_integer__value',
             'lucky_integer_arrayrefs' => 'lucky_arrayref_integers',
             'lucky_integer_arrayrefs_deref' => 'lucky_arrayref_integers__deref',
             'lucky_number_array' => 'lucky_array_number',
             'lucky_number_arrayref' => 'lucky_arrayref_number',
             'lucky_number_arrayref_entry' => 'lucky_arrayref_number_entry',
             'lucky_number_arrayref_key' => 'lucky_arrayref_number_key',
             'lucky_number_arrayref_value' => 'lucky_arrayref_number_value',
             'lucky_number_arrayrefs' => 'lucky_arrayref_numbers',
             'lucky_number_arrayrefs_deref' => 'lucky_arrayref_numbers_deref',
             'lucky_string_array' => 'lucky_array_string',
             'lucky_string_arrayref' => 'lucky_arrayref_string',
             'lucky_string_arrayref_entry' => 'lucky_arrayref_string_entry',
             'lucky_string_arrayref_key' => 'lucky_arrayref_string_key',
             'lucky_string_arrayref_value' => 'lucky_arrayref_string_value',
             'lucky_string_arrayrefs' => 'lucky_arrayref_strings',
             'lucky_string_arrayrefs_deref' => 'lucky_arrayref_strings_deref',
             'new_unordered_map' => 'new_umap',
             'new_vector_unordered_map' => 'new_umap_vector',
             'ninteger_arrayref' => 'narrayref_integer',
             'ninteger_arrayref_arrayref' => 'narrayref_arrayref_integer',
             'ninteger_arrayref_hashentry' => 'nhash_arrayref_integer__hashentry',
             'ninteger_arrayref_hashref' => 'nhashref_arrayref_integer',
             'ninteger_arrayref_hashref_hashentry' => 'nhash_hashref_arrayref_integer__hashentry',
             'ninteger_arrayref_hashref_hashref' => 'nhashref_hashref_arrayref_integer',
             'ninteger_hashentry' => 'nhash_integer__hashentry',
             'ninteger_hashref' => 'nhashref_integer',
             'nnumber_arrayref' => 'narrayref_number',
             'nnumber_arrayref_arrayref' => 'narrayref_arrayref_number',
             'nnumber_arrayref_hashentry' => 'nhash_arrayref_number__hashentry',
             'nnumber_arrayref_hashref' => 'nhashref_arrayref_number',
             'nnumber_arrayref_hashref_hashentry' => 'nhash_hashref_arrayref_number__hashentry',
             'nnumber_arrayref_hashref_hashref' => 'nhashref_hashref_arrayref_number',
             'nnumber_hashentry' => 'nhash_number__hashentry',
             'nnumber_hashref' => 'nhashref_number',
             'nstring_arrayref' => 'narrayref_string',
             'nstring_arrayref_arrayref' => 'narrayref_arrayref_string',
             'nstring_arrayref_hashentry' => 'nhash_arrayref_string__hashentry',
             'nstring_arrayref_hashref' => 'nhashref_arrayref_string',
             'nstring_arrayref_hashref_hashentry' => 'nhash_hashref_arrayref_string__hashentry',
             'nstring_arrayref_hashref_hashref' => 'nhashref_hashref_arrayref_string',
             'nstring_hashentry' => 'nhash_string__hashentry',
             'nstring_hashref' => 'nhashref_string',
             'number_arrayref' => 'arrayref_number',
             'number_arrayref_CHECK' => 'arrayref_number_CHECK',
             'number_arrayref_CHECKTRACE' => 'arrayref_number_CHECKTRACE',
             'number_arrayref_arrayref' => 'arrayref_arrayref_number',
             'number_arrayref_arrayref_CHECK' => 'arrayref_arrayref_number_CHECK',
             'number_arrayref_arrayref_CHECKTRACE' => 'arrayref_arrayref_number_CHECKTRACE',
             'number_arrayref_hashref' => 'hashref_arrayref_number',
             'number_arrayref_hashref_CHECK' => 'hashref_arrayref_number_CHECK',
             'number_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_number_CHECKTRACE',
             'number_arrayref_hashref_const_iterator' => 'hashref_arrayref_number_const_iterator',
             'number_arrayref_hashref_hashref' => 'hashref_hashref_arrayref_number',
             'number_arrayref_hashref_hashref_CHECK' => 'hashref_hashref_arrayref_number_CHECK',
             'number_arrayref_hashref_hashref_CHECKTRACE' => 'hashref_hashref_arrayref_number_CHECKTRACE',
             'number_arrayref_hashref_hashref_const_iterator' => 'hashref_hashref_arrayref_number_const_iterator',
             'number_arrayref_hashref_to_string' => 'hashref_arrayref_number_to_string',
             'number_arrayref_hashref_to_string_compact' => 'hashref_arrayref_number_to_string_compact',
             'number_arrayref_hashref_to_string_expand' => 'hashref_arrayref_number_to_string_expand',
             'number_arrayref_hashref_to_string_format' => 'hashref_arrayref_number_to_string_format',
             'number_arrayref_hashref_to_string_pretty' => 'hashref_arrayref_number_to_string_pretty',
             'number_arrayref_hashref_typetest0' => 'hashref_arrayref_number_typetest0',
             'number_arrayref_hashref_typetest1' => 'hashref_arrayref_number_typetest1',
             'number_arrayref_to_gsl_matrix' => 'arrayref_number_to_gsl_matrix',
             'number_arrayref_to_string' => 'arrayref_number_to_string',
             'number_arrayref_to_string_compact' => 'arrayref_number_to_string_compact',
             'number_arrayref_to_string_expand' => 'arrayref_number_to_string_expand',
             'number_arrayref_to_string_format' => 'arrayref_number_to_string_format',
             'number_arrayref_to_string_pretty' => 'arrayref_number_to_string_pretty',
             'number_arrayref_typetest0' => 'arrayref_number_typetest0',
             'number_arrayref_typetest1' => 'arrayref_number_typetest1',
             'number_hashref' => 'hashref_number',
             'number_hashref_CHECK' => 'hashref_number_CHECK',
             'number_hashref_CHECKTRACE' => 'hashref_number_CHECKTRACE',
             'number_hashref_const_iterator' => 'hashref_number_const_iterator',
             'number_hashref_to_string' => 'hashref_number_to_string',
             'number_hashref_to_string_compact' => 'hashref_number_to_string_compact',
             'number_hashref_to_string_expand' => 'hashref_number_to_string_expand',
             'number_hashref_to_string_format' => 'hashref_number_to_string_format',
             'number_hashref_to_string_pretty' => 'hashref_number_to_string_pretty',
             'number_hashref_typetest0' => 'hashref_number_typetest0',
             'number_hashref_typetest1' => 'hashref_number_typetest1',
             'output_avref_av' => 'output_av_avref',
             'output_avref_hv' => 'output_hv_avref',
             'output_avref_hvref' => 'output_hvref_avref',
             'output_avref_hvref_hv' => 'output_hv_hvref_avref',
             'output_avref_hvref_hvref' => 'output_hvref_hvref_avref',
             'output_vector_unordered_map' => 'output_umap_vector',
             'output_vector_unordered_map_unordered_map' => 'output_umap_umap_vector',
             'possible_TYPE_arrayref_hash' => 'possible_hash_arrayref_TYPE',
             'possible_TYPE_arrayref_hashref_hash' => 'possible_hash_hashref_arrayref_TYPE',
             'possible_integer_array' => 'possible_array_integer',
             'possible_integer_array_element' => 'possible_array_integer__element',
             'possible_integer_array_length' => 'possible_array_integer__length',
             'possible_integer_arrayref' => 'possible_arrayref_integer',
             'possible_integer_arrayref_array' => 'possible_array_arrayref_integer',
             'possible_integer_arrayref_array_element' => 'possible_array_arrayref_integer__element',
             'possible_integer_arrayref_array_length' => 'possible_array_arrayref_integer__length',
             'possible_integer_arrayref_arrayref' => 'possible_arrayref_arrayref_integer',
             'possible_integer_arrayref_hash' => 'possible_hash_arrayref_integer',
             'possible_integer_arrayref_hash_num_keys' => 'possible_hash_arrayref_integer__num_keys',
             'possible_integer_arrayref_hashentry' => 'possible_hash_arrayref_integer__hashentry',
             'possible_integer_arrayref_hashentry_key' => 'possible_hash_arrayref_integer__hashentry_key',
             'possible_integer_arrayref_hashentry_key_string' => 'possible_hash_arrayref_integer__hashentry_key_string',
             'possible_integer_arrayref_hashentry_value' => 'possible_hash_arrayref_integer__hashentry_value',
             'possible_integer_arrayref_hashref' => 'possible_hashref_arrayref_integer',
             'possible_integer_arrayref_hashref_hash' => 'possible_hash_hashref_arrayref_integer',
             'possible_integer_arrayref_hashref_hash_num_keys' => 'possible_hash_hashref_arrayref_integer__num_keys',
             'possible_integer_arrayref_hashref_hashentry' => 'possible_hash_hashref_arrayref_integer__hashentry',
             'possible_integer_arrayref_hashref_hashentry_key' => 'possible_hash_hashref_arrayref_integer__hashentry_key',
             'possible_integer_arrayref_hashref_hashentry_key_string' => 'possible_hash_hashref_arrayref_integer__hashentry_key_string',
             'possible_integer_arrayref_hashref_hashentry_value' => 'possible_hash_hashref_arrayref_integer__hashentry_value',
             'possible_integer_arrayref_hashref_hashref' => 'possible_hashref_hashref_arrayref_integer',
             'possible_integer_hash' => 'possible_hash_integer',
             'possible_integer_hash_num_keys' => 'possible_hash_integer__num_keys',
             'possible_integer_hashentry' => 'possible_hash_integer__hashentry',
             'possible_integer_hashentry_key' => 'possible_hash_integer__hashentry_key',
             'possible_integer_hashentry_key_string' => 'possible_hash_integer__hashentry_key_string',
             'possible_integer_hashentry_value' => 'possible_hash_integer__hashentry_value',
             'possible_integer_hashref' => 'possible_hashref_integer',
             'possible_number_array' => 'possible_array_number',
             'possible_number_array_element' => 'possible_array_number__element',
             'possible_number_array_length' => 'possible_array_number__length',
             'possible_number_arrayref' => 'possible_arrayref_number',
             'possible_number_arrayref_array' => 'possible_array_arrayref_number',
             'possible_number_arrayref_array_element' => 'possible_array_arrayref_number__element',
             'possible_number_arrayref_array_length' => 'possible_array_arrayref_number__length',
             'possible_number_arrayref_arrayref' => 'possible_arrayref_arrayref_number',
             'possible_number_arrayref_hash' => 'possible_hash_arrayref_number',
             'possible_number_arrayref_hash_num_keys' => 'possible_hash_arrayref_number__num_keys',
             'possible_number_arrayref_hashentry' => 'possible_hash_arrayref_number__hashentry',
             'possible_number_arrayref_hashentry_key' => 'possible_hash_arrayref_number__hashentry_key',
             'possible_number_arrayref_hashentry_key_string' => 'possible_hash_arrayref_number__hashentry_key_string',
             'possible_number_arrayref_hashentry_value' => 'possible_hash_arrayref_number__hashentry_value',
             'possible_number_arrayref_hashref' => 'possible_hashref_arrayref_number',
             'possible_number_arrayref_hashref_hash' => 'possible_hash_hashref_arrayref_number',
             'possible_number_arrayref_hashref_hash_num_keys' => 'possible_hash_hashref_arrayref_number__num_keys',
             'possible_number_arrayref_hashref_hashentry' => 'possible_hash_hashref_arrayref_number__hashentry',
             'possible_number_arrayref_hashref_hashentry_key' => 'possible_hash_hashref_arrayref_number__hashentry_key',
             'possible_number_arrayref_hashref_hashentry_key_string' => 'possible_hash_hashref_arrayref_number__hashentry_key_string',
             'possible_number_arrayref_hashref_hashentry_value' => 'possible_hash_hashref_arrayref_number__hashentry_value',
             'possible_number_arrayref_hashref_hashref' => 'possible_hashref_hashref_arrayref_number',
             'possible_number_hash' => 'possible_hash_number',
             'possible_number_hash_num_keys' => 'possible_hash_number__num_keys',
             'possible_number_hashentry' => 'possible_hash_number__hashentry',
             'possible_number_hashentry_key' => 'possible_hash_number__hashentry_key',
             'possible_number_hashentry_key_string' => 'possible_hash_number__hashentry_key_string',
             'possible_number_hashentry_value' => 'possible_hash_number__hashentry_value',
             'possible_number_hashref' => 'possible_hashref_number',
             'possible_string_array' => 'possible_array_string',
             'possible_string_array_element' => 'possible_array_string__element',
             'possible_string_array_length' => 'possible_array_string__length',
             'possible_string_arrayref' => 'possible_arrayref_string',
             'possible_string_arrayref_array' => 'possible_array_arrayref_string',
             'possible_string_arrayref_array_element' => 'possible_array_arrayref_string__element',
             'possible_string_arrayref_array_length' => 'possible_array_arrayref_string__length',
             'possible_string_arrayref_arrayref' => 'possible_arrayref_arrayref_string',
             'possible_string_arrayref_hash' => 'possible_hash_arrayref_string',
             'possible_string_arrayref_hash_num_keys' => 'possible_hash_arrayref_string__num_keys',
             'possible_string_arrayref_hashentry' => 'possible_hash_arrayref_string__hashentry',
             'possible_string_arrayref_hashentry_key' => 'possible_hash_arrayref_string__hashentry_key',
             'possible_string_arrayref_hashentry_key_string' => 'possible_hash_arrayref_string__hashentry_key_string',
             'possible_string_arrayref_hashentry_value' => 'possible_hash_arrayref_string__hashentry_value',
             'possible_string_arrayref_hashref' => 'possible_hashref_arrayref_string',
             'possible_string_arrayref_hashref_hash' => 'possible_hash_hashref_arrayref_string',
             'possible_string_arrayref_hashref_hash_num_keys' => 'possible_hash_hashref_arrayref_string__num_keys',
             'possible_string_arrayref_hashref_hashentry' => 'possible_hash_hashref_arrayref_string__hashentry',
             'possible_string_arrayref_hashref_hashentry_key' => 'possible_hash_hashref_arrayref_string__hashentry_key',
             'possible_string_arrayref_hashref_hashentry_key_string' => 'possible_hash_hashref_arrayref_string__hashentry_key_string',
             'possible_string_arrayref_hashref_hashentry_value' => 'possible_hash_hashref_arrayref_string__hashentry_value',
             'possible_string_arrayref_hashref_hashref' => 'possible_hashref_hashref_arrayref_string',
             'possible_string_hash' => 'possible_hash_string',
             'possible_string_hash_num_keys' => 'possible_hash_string__num_keys',
             'possible_string_hashentry' => 'possible_hash_string__hashentry',
             'possible_string_hashentry_key' => 'possible_hash_string__hashentry_key',
             'possible_string_hashentry_key_string' => 'possible_hash_string__hashentry_key_string',
             'possible_string_hashentry_value' => 'possible_hash_string__hashentry_value',
             'possible_string_hashref' => 'possible_hashref_string',
             'string_arrayref' => 'arrayref_string',
             'string_arrayref_CHECK' => 'arrayref_string_CHECK',
             'string_arrayref_CHECKTRACE' => 'arrayref_string_CHECKTRACE',
             'string_arrayref_arrayref' => 'arrayref_arrayref_string',
             'string_arrayref_arrayref_CHECK' => 'arrayref_arrayref_string_CHECK',
             'string_arrayref_arrayref_CHECKTRACE' => 'arrayref_arrayref_string_CHECKTRACE',
             'string_arrayref_hashref' => 'hashref_arrayref_string',
             'string_arrayref_hashref_CHECK' => 'hashref_arrayref_string_CHECK',
             'string_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_string_CHECKTRACE',
             'string_arrayref_hashref_const_iterator' => 'hashref_arrayref_string_const_iterator',
             'string_arrayref_hashref_hashref' => 'hashref_hashref_arrayref_string',
             'string_arrayref_hashref_hashref_CHECK' => 'hashref_hashref_arrayref_string_CHECK',
             'string_arrayref_hashref_hashref_CHECKTRACE' => 'hashref_hashref_arrayref_string_CHECKTRACE',
             'string_arrayref_hashref_hashref_const_iterator' => 'hashref_hashref_arrayref_string_const_iterator',
             'string_arrayref_hashref_to_string' => 'hashref_arrayref_string_to_string',
             'string_arrayref_hashref_to_string_compact' => 'hashref_arrayref_string_to_string_compact',
             'string_arrayref_hashref_to_string_expand' => 'hashref_arrayref_string_to_string_expand',
             'string_arrayref_hashref_to_string_format' => 'hashref_arrayref_string_to_string_format',
             'string_arrayref_hashref_to_string_pretty' => 'hashref_arrayref_string_to_string_pretty',
             'string_arrayref_hashref_typetest0' => 'hashref_arrayref_string_typetest0',
             'string_arrayref_hashref_typetest1' => 'hashref_arrayref_string_typetest1',
             'string_arrayref_to_string' => 'arrayref_string_to_string',
             'string_arrayref_to_string_compact' => 'arrayref_string_to_string_compact',
             'string_arrayref_to_string_expand' => 'arrayref_string_to_string_expand',
             'string_arrayref_to_string_format' => 'arrayref_string_to_string_format',
             'string_arrayref_to_string_pretty' => 'arrayref_string_to_string_pretty',
             'string_arrayref_typetest0' => 'arrayref_string_typetest0',
             'string_arrayref_typetest1' => 'arrayref_string_typetest1',
             'string_hashref' => 'hashref_string',
             'string_hashref_CHECK' => 'hashref_string_CHECK',
             'string_hashref_CHECKTRACE' => 'hashref_string_CHECKTRACE',
             'string_hashref_const_iterator' => 'hashref_string_const_iterator',
             'string_hashref_to_string' => 'hashref_string_to_string',
             'string_hashref_to_string_compact' => 'hashref_string_to_string_compact',
             'string_hashref_to_string_expand' => 'hashref_string_to_string_expand',
             'string_hashref_to_string_format' => 'hashref_string_to_string_format',
             'string_hashref_to_string_pretty' => 'hashref_string_to_string_pretty',
             'string_hashref_typetest0' => 'hashref_string_typetest0',
             'string_hashref_typetest1' => 'hashref_string_typetest1'
           },
  'h' => {
           'XS_pack_integer_arrayref' => 'XS_pack_arrayref_integer',
           'XS_pack_integer_arrayref_arrayref' => 'XS_pack_arrayref_arrayref_integer',
           'XS_pack_integer_arrayref_hashref' => 'XS_pack_hashref_arrayref_integer',
           'XS_pack_integer_arrayref_hashref_hashref' => 'XS_pack_hashref_hashref_arrayref_integer',
           'XS_pack_integer_hashref_hashref' => 'XS_pack_hashref_hashref_integer',
           'XS_pack_number_arrayref' => 'XS_pack_arrayref_number',
           'XS_pack_number_arrayref_arrayref' => 'XS_pack_arrayref_arrayref_number',
           'XS_pack_number_arrayref_hashref' => 'XS_pack_hashref_arrayref_number',
           'XS_pack_number_arrayref_hashref_hashref' => 'XS_pack_hashref_hashref_arrayref_number',
           'XS_pack_number_hashref_hashref' => 'XS_pack_hashref_hashref_number',
           'XS_pack_string_arrayref' => 'XS_pack_arrayref_string',
           'XS_pack_string_arrayref_arrayref' => 'XS_pack_arrayref_arrayref_string',
           'XS_pack_string_arrayref_hashref' => 'XS_pack_hashref_arrayref_string',
           'XS_pack_string_arrayref_hashref_hashref' => 'XS_pack_hashref_hashref_arrayref_string',
           'XS_pack_string_hashref_hashref' => 'XS_pack_hashref_hashref_string',
           'XS_unpack_integer_arrayref' => 'XS_unpack_arrayref_integer',
           'XS_unpack_integer_arrayref_arrayref' => 'XS_unpack_arrayref_arrayref_integer',
           'XS_unpack_integer_arrayref_hashref' => 'XS_unpack_hashref_arrayref_integer',
           'XS_unpack_integer_arrayref_hashref_hashref' => 'XS_unpack_hashref_hashref_arrayref_integer',
           'XS_unpack_integer_hashref' => 'XS_unpack_hashref_integer',
           'XS_unpack_integer_hashref_arrayref' => 'XS_unpack_arrayref_hashref_integer',
           'XS_unpack_integer_hashref_hashref' => 'XS_unpack_hashref_hashref_integer',
           'XS_unpack_number_arrayref' => 'XS_unpack_arrayref_number',
           'XS_unpack_number_arrayref_arrayref' => 'XS_unpack_arrayref_arrayref_number',
           'XS_unpack_number_arrayref_hashref' => 'XS_unpack_hashref_arrayref_number',
           'XS_unpack_number_arrayref_hashref_hashref' => 'XS_unpack_hashref_hashref_arrayref_number',
           'XS_unpack_number_hashref' => 'XS_unpack_hashref_number',
           'XS_unpack_number_hashref_arrayref' => 'XS_unpack_arrayref_hashref_number',
           'XS_unpack_number_hashref_hashref' => 'XS_unpack_hashref_hashref_number',
           'XS_unpack_string_arrayref' => 'XS_unpack_arrayref_string',
           'XS_unpack_string_arrayref_arrayref' => 'XS_unpack_arrayref_arrayref_string',
           'XS_unpack_string_arrayref_hashref' => 'XS_unpack_hashref_arrayref_string',
           'XS_unpack_string_arrayref_hashref_hashref' => 'XS_unpack_hashref_hashref_arrayref_string',
           'XS_unpack_string_hashref' => 'XS_unpack_hashref_string',
           'XS_unpack_string_hashref_arrayref' => 'XS_unpack_arrayref_hashref_string',
           'XS_unpack_string_hashref_hashref' => 'XS_unpack_hashref_hashref_string',
           'gsl_matrix_to_number_arrayref' => 'gsl_matrix_to_arrayref_number',
           'gsl_matrix_to_number_arrayref_arrayref' => 'gsl_matrix_to_arrayref_arrayref_number',
           'input_avref_hvref' => 'input_hvref_avref',
           'input_avref_hvref_hvref' => 'input_hvref_hvref_avref',
           'input_hvref_avref' => 'input_avref_hvref',
           'input_number_arrayref' => 'input_arrayref_number',
           'input_unordered_map_unordered_map' => 'input_umap_umap',
           'input_unordered_map_vector' => 'input_vector_umap',
           'input_vector_unordered_map' => 'input_umap_vector',
           'input_vector_unordered_map_unordered_map' => 'input_umap_umap_vector',
           'integer_arrayref' => 'arrayref_integer',
           'integer_arrayref_CHECK' => 'arrayref_integer_CHECK',
           'integer_arrayref_CHECKTRACE' => 'arrayref_integer_CHECKTRACE',
           'integer_arrayref_arrayref' => 'arrayref_arrayref_integer',
           'integer_arrayref_arrayref_CHECK' => 'arrayref_arrayref_integer_CHECK',
           'integer_arrayref_arrayref_CHECKTRACE' => 'arrayref_arrayref_integer_CHECKTRACE',
           'integer_arrayref_arrayref_const_iterator' => 'arrayref_arrayref_integer_const_iterator',
           'integer_arrayref_arrayref_hashref_CHECK' => 'hashref_arrayref_arrayref_integer_CHECK',
           'integer_arrayref_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_arrayref_integer_CHECKTRACE',
           'integer_arrayref_arrayref_iterator' => 'arrayref_arrayref_integer_iterator',
           'integer_arrayref_arrayref_to_string' => 'arrayref_arrayref_integer_to_string',
           'integer_arrayref_arrayref_typetest0' => 'arrayref_arrayref_integer_typetest0',
           'integer_arrayref_arrayref_typetest1' => 'arrayref_arrayref_integer_typetest1',
           'integer_arrayref_const_iterator' => 'arrayref_integer_const_iterator',
           'integer_arrayref_hashref' => 'hashref_arrayref_integer',
           'integer_arrayref_hashref_CHECK' => 'hashref_arrayref_integer_CHECK',
           'integer_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_integer_CHECKTRACE',
           'integer_arrayref_hashref_const_iterator' => 'hashref_arrayref_integer_const_iterator',
           'integer_arrayref_hashref_hashref' => 'hashref_hashref_arrayref_integer',
           'integer_arrayref_hashref_hashref_CHECK' => 'hashref_hashref_arrayref_integer_CHECK',
           'integer_arrayref_hashref_hashref_CHECKTRACE' => 'hashref_hashref_arrayref_integer_CHECKTRACE',
           'integer_arrayref_hashref_hashref_const_iterator' => 'hashref_hashref_arrayref_integer_const_iterator',
           'integer_arrayref_hashref_hashref_iterator' => 'hashref_hashref_arrayref_integer_iterator',
           'integer_arrayref_hashref_hashref_to_string' => 'hashref_hashref_arrayref_integer_to_string',
           'integer_arrayref_hashref_hashref_to_string_compact' => 'hashref_hashref_arrayref_integer_to_string_compact',
           'integer_arrayref_hashref_hashref_to_string_expand' => 'hashref_hashref_arrayref_integer_to_string_expand',
           'integer_arrayref_hashref_hashref_to_string_extend' => 'hashref_hashref_arrayref_integer_to_string_extend',
           'integer_arrayref_hashref_hashref_to_string_format' => 'hashref_hashref_arrayref_integer_to_string_format',
           'integer_arrayref_hashref_hashref_to_string_pretty' => 'hashref_hashref_arrayref_integer_to_string_pretty',
           'integer_arrayref_hashref_hashref_typetest0' => 'hashref_hashref_arrayref_integer_typetest0',
           'integer_arrayref_hashref_hashref_typetest1' => 'hashref_hashref_arrayref_integer_typetest1',
           'integer_arrayref_hashref_iterator' => 'hashref_arrayref_integer_iterator',
           'integer_arrayref_hashref_to_string' => 'hashref_arrayref_integer_to_string',
           'integer_arrayref_hashref_to_string_compact' => 'hashref_arrayref_integer_to_string_compact',
           'integer_arrayref_hashref_to_string_expand' => 'hashref_arrayref_integer_to_string_expand',
           'integer_arrayref_hashref_to_string_extend' => 'hashref_arrayref_integer_to_string_extend',
           'integer_arrayref_hashref_to_string_format' => 'hashref_arrayref_integer_to_string_format',
           'integer_arrayref_hashref_to_string_pretty' => 'hashref_arrayref_integer_to_string_pretty',
           'integer_arrayref_hashref_typetest0' => 'hashref_arrayref_integer_typetest0',
           'integer_arrayref_hashref_typetest1' => 'hashref_arrayref_integer_typetest1',
           'integer_arrayref_iterator' => 'arrayref_integer_iterator',
           'integer_arrayref_to_string' => 'arrayref_integer_to_string',
           'integer_arrayref_to_string_compact' => 'arrayref_integer_to_string_compact',
           'integer_arrayref_to_string_extend' => 'arrayref_integer_to_string_extend',
           'integer_arrayref_to_string_format' => 'arrayref_integer_to_string_format',
           'integer_arrayref_to_string_pretty' => 'arrayref_integer_to_string_pretty',
           'integer_arrayref_typetest0' => 'arrayref_integer_typetest0',
           'integer_arrayref_typetest1' => 'arrayref_integer_typetest1',
           'integer_hashref' => 'hashref_integer',
           'integer_hashref_CHECK' => 'hashref_integer_CHECK',
           'integer_hashref_CHECKTRACE' => 'hashref_integer_CHECKTRACE',
           'integer_hashref_arrayref' => 'arrayref_hashref_integer',
           'integer_hashref_arrayref_CHECK' => 'arrayref_hashref_integer_CHECK',
           'integer_hashref_arrayref_CHECKTRACE' => 'arrayref_hashref_integer_CHECKTRACE',
           'integer_hashref_arrayref_const_iterator' => 'arrayref_hashref_integer_const_iterator',
           'integer_hashref_arrayref_hashref_CHECK' => 'hashref_arrayref_hashref_integer_CHECK',
           'integer_hashref_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_hashref_integer_CHECKTRACE',
           'integer_hashref_arrayref_iterator' => 'arrayref_hashref_integer_iterator',
           'integer_hashref_arrayref_to_string' => 'arrayref_hashref_integer_to_string',
           'integer_hashref_arrayref_typetest0' => 'arrayref_hashref_integer_typetest0',
           'integer_hashref_arrayref_typetest1' => 'arrayref_hashref_integer_typetest1',
           'integer_hashref_const_iterator' => 'hashref_integer_const_iterator',
           'integer_hashref_hashref' => 'hashref_hashref_integer',
           'integer_hashref_hashref_CHECK' => 'hashref_hashref_integer_CHECK',
           'integer_hashref_hashref_CHECKTRACE' => 'hashref_hashref_integer_CHECKTRACE',
           'integer_hashref_hashref_const_iterator' => 'hashref_hashref_integer_const_iterator',
           'integer_hashref_hashref_hashref_CHECK' => 'hashref_hashref_hashref_integer_CHECK',
           'integer_hashref_hashref_hashref_CHECKTRACE' => 'hashref_hashref_hashref_integer_CHECKTRACE',
           'integer_hashref_hashref_iterator' => 'hashref_hashref_integer_iterator',
           'integer_hashref_hashref_to_string' => 'hashref_hashref_integer_to_string',
           'integer_hashref_hashref_typetest0' => 'hashref_hashref_integer_typetest0',
           'integer_hashref_hashref_typetest1' => 'hashref_hashref_integer_typetest1',
           'integer_hashref_iterator' => 'hashref_integer_iterator',
           'integer_hashref_to_string' => 'hashref_integer_to_string',
           'integer_hashref_to_string_compact' => 'hashref_integer_to_string_compact',
           'integer_hashref_to_string_expand' => 'hashref_integer_to_string_expand',
           'integer_hashref_to_string_format' => 'hashref_integer_to_string_format',
           'integer_hashref_to_string_pretty' => 'hashref_integer_to_string_pretty',
           'integer_hashref_typetest0' => 'hashref_integer_typetest0',
           'integer_hashref_typetest1' => 'hashref_integer_typetest1',
           'lucky_integer_arrayref_hashrefs' => 'lucky_hashrefs_arrayref_integer',
           'lucky_integer_arrayrefs' => 'lucky_arrayref_integers',
           'lucky_number_arrayref_hashrefs' => 'lucky_hashrefs_arrayref_number',
           'lucky_number_arrayrefs' => 'lucky_arrayref_numbers',
           'lucky_string_arrayref_hashrefs' => 'lucky_hashrefs_arrayref_string',
           'lucky_string_arrayrefs' => 'lucky_arrayref_strings',
           'number_arrayref' => 'arrayref_number',
           'number_arrayref_CHECK' => 'arrayref_number_CHECK',
           'number_arrayref_CHECKTRACE' => 'arrayref_number_CHECKTRACE',
           'number_arrayref_arrayref' => 'arrayref_arrayref_number',
           'number_arrayref_arrayref_CHECK' => 'arrayref_arrayref_number_CHECK',
           'number_arrayref_arrayref_CHECKTRACE' => 'arrayref_arrayref_number_CHECKTRACE',
           'number_arrayref_arrayref_const_iterator' => 'arrayref_arrayref_number_const_iterator',
           'number_arrayref_arrayref_hashref_CHECK' => 'hashref_arrayref_arrayref_number_CHECK',
           'number_arrayref_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_arrayref_number_CHECKTRACE',
           'number_arrayref_arrayref_iterator' => 'arrayref_arrayref_number_iterator',
           'number_arrayref_arrayref_to_string' => 'arrayref_arrayref_number_to_string',
           'number_arrayref_arrayref_typetest0' => 'arrayref_arrayref_number_typetest0',
           'number_arrayref_arrayref_typetest1' => 'arrayref_arrayref_number_typetest1',
           'number_arrayref_const_iterator' => 'arrayref_number_const_iterator',
           'number_arrayref_hashref' => 'hashref_arrayref_number',
           'number_arrayref_hashref_CHECK' => 'hashref_arrayref_number_CHECK',
           'number_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_number_CHECKTRACE',
           'number_arrayref_hashref_const_iterator' => 'hashref_arrayref_number_const_iterator',
           'number_arrayref_hashref_hashref' => 'hashref_hashref_arrayref_number',
           'number_arrayref_hashref_hashref_CHECK' => 'hashref_hashref_arrayref_number_CHECK',
           'number_arrayref_hashref_hashref_CHECKTRACE' => 'hashref_hashref_arrayref_number_CHECKTRACE',
           'number_arrayref_hashref_hashref_const_iterator' => 'hashref_hashref_arrayref_number_const_iterator',
           'number_arrayref_hashref_hashref_iterator' => 'hashref_hashref_arrayref_number_iterator',
           'number_arrayref_hashref_hashref_to_string' => 'hashref_hashref_arrayref_number_to_string',
           'number_arrayref_hashref_hashref_to_string_compact' => 'hashref_hashref_arrayref_number_to_string_compact',
           'number_arrayref_hashref_hashref_to_string_expand' => 'hashref_hashref_arrayref_number_to_string_expand',
           'number_arrayref_hashref_hashref_to_string_extend' => 'hashref_hashref_arrayref_number_to_string_extend',
           'number_arrayref_hashref_hashref_to_string_format' => 'hashref_hashref_arrayref_number_to_string_format',
           'number_arrayref_hashref_hashref_to_string_pretty' => 'hashref_hashref_arrayref_number_to_string_pretty',
           'number_arrayref_hashref_hashref_typetest0' => 'hashref_hashref_arrayref_number_typetest0',
           'number_arrayref_hashref_hashref_typetest1' => 'hashref_hashref_arrayref_number_typetest1',
           'number_arrayref_hashref_iterator' => 'hashref_arrayref_number_iterator',
           'number_arrayref_hashref_to_string' => 'hashref_arrayref_number_to_string',
           'number_arrayref_hashref_to_string_compact' => 'hashref_arrayref_number_to_string_compact',
           'number_arrayref_hashref_to_string_expand' => 'hashref_arrayref_number_to_string_expand',
           'number_arrayref_hashref_to_string_extend' => 'hashref_arrayref_number_to_string_extend',
           'number_arrayref_hashref_to_string_format' => 'hashref_arrayref_number_to_string_format',
           'number_arrayref_hashref_to_string_pretty' => 'hashref_arrayref_number_to_string_pretty',
           'number_arrayref_hashref_typetest0' => 'hashref_arrayref_number_typetest0',
           'number_arrayref_hashref_typetest1' => 'hashref_arrayref_number_typetest1',
           'number_arrayref_iterator' => 'arrayref_number_iterator',
           'number_arrayref_to_gsl_matrix' => 'arrayref_number_to_gsl_matrix',
           'number_arrayref_to_string' => 'arrayref_number_to_string',
           'number_arrayref_to_string_compact' => 'arrayref_number_to_string_compact',
           'number_arrayref_to_string_extend' => 'arrayref_number_to_string_extend',
           'number_arrayref_to_string_format' => 'arrayref_number_to_string_format',
           'number_arrayref_to_string_pretty' => 'arrayref_number_to_string_pretty',
           'number_arrayref_typetest0' => 'arrayref_number_typetest0',
           'number_arrayref_typetest1' => 'arrayref_number_typetest1',
           'number_hashref' => 'hashref_number',
           'number_hashref_CHECK' => 'hashref_number_CHECK',
           'number_hashref_CHECKTRACE' => 'hashref_number_CHECKTRACE',
           'number_hashref_arrayref' => 'arrayref_hashref_number',
           'number_hashref_arrayref_CHECK' => 'arrayref_hashref_number_CHECK',
           'number_hashref_arrayref_CHECKTRACE' => 'arrayref_hashref_number_CHECKTRACE',
           'number_hashref_arrayref_const_iterator' => 'arrayref_hashref_number_const_iterator',
           'number_hashref_arrayref_hashref_CHECK' => 'hashref_arrayref_hashref_number_CHECK',
           'number_hashref_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_hashref_number_CHECKTRACE',
           'number_hashref_arrayref_iterator' => 'arrayref_hashref_number_iterator',
           'number_hashref_arrayref_to_string' => 'arrayref_hashref_number_to_string',
           'number_hashref_arrayref_typetest0' => 'arrayref_hashref_number_typetest0',
           'number_hashref_arrayref_typetest1' => 'arrayref_hashref_number_typetest1',
           'number_hashref_const_iterator' => 'hashref_number_const_iterator',
           'number_hashref_hashref' => 'hashref_hashref_number',
           'number_hashref_hashref_CHECK' => 'hashref_hashref_number_CHECK',
           'number_hashref_hashref_CHECKTRACE' => 'hashref_hashref_number_CHECKTRACE',
           'number_hashref_hashref_const_iterator' => 'hashref_hashref_number_const_iterator',
           'number_hashref_hashref_hashref_CHECK' => 'hashref_hashref_hashref_number_CHECK',
           'number_hashref_hashref_hashref_CHECKTRACE' => 'hashref_hashref_hashref_number_CHECKTRACE',
           'number_hashref_hashref_iterator' => 'hashref_hashref_number_iterator',
           'number_hashref_hashref_to_string' => 'hashref_hashref_number_to_string',
           'number_hashref_hashref_typetest0' => 'hashref_hashref_number_typetest0',
           'number_hashref_hashref_typetest1' => 'hashref_hashref_number_typetest1',
           'number_hashref_iterator' => 'hashref_number_iterator',
           'number_hashref_to_string' => 'hashref_number_to_string',
           'number_hashref_to_string_compact' => 'hashref_number_to_string_compact',
           'number_hashref_to_string_expand' => 'hashref_number_to_string_expand',
           'number_hashref_to_string_format' => 'hashref_number_to_string_format',
           'number_hashref_to_string_pretty' => 'hashref_number_to_string_pretty',
           'number_hashref_typetest0' => 'hashref_number_typetest0',
           'number_hashref_typetest1' => 'hashref_number_typetest1',
           'output_avref_hvref' => 'output_hvref_avref',
           'output_avref_hvref_hvref' => 'output_hvref_hvref_avref',
           'possible_integer_arrayref' => 'possible_arrayref_integer',
           'possible_integer_arrayref_arrayref' => 'possible_arrayref_arrayref_integer',
           'possible_integer_arrayref_arrayref_hashref' => 'possible_hashref_arrayref_arrayref_integer',
           'possible_integer_arrayref_hashref' => 'possible_hashref_arrayref_integer',
           'possible_integer_arrayref_hashref_hashref' => 'possible_hashref_hashref_arrayref_integer',
           'possible_integer_hashref' => 'possible_hashref_integer',
           'possible_integer_hashref_arrayref' => 'possible_arrayref_hashref_integer',
           'possible_integer_hashref_arrayref_hashref' => 'possible_hashref_arrayref_hashref_integer',
           'possible_integer_hashref_hashref' => 'possible_hashref_hashref_integer',
           'possible_integer_hashref_hashref_hashref' => 'possible_hashref_hashref_hashref_integer',
           'possible_number_arrayref' => 'possible_arrayref_number',
           'possible_number_arrayref_arrayref' => 'possible_arrayref_arrayref_number',
           'possible_number_arrayref_arrayref_hashref' => 'possible_hashref_arrayref_arrayref_number',
           'possible_number_arrayref_hashref' => 'possible_hashref_arrayref_number',
           'possible_number_arrayref_hashref_hashref' => 'possible_hashref_hashref_arrayref_number',
           'possible_number_hashref' => 'possible_hashref_number',
           'possible_number_hashref_arrayref' => 'possible_arrayref_hashref_number',
           'possible_number_hashref_arrayref_hashref' => 'possible_hashref_arrayref_hashref_number',
           'possible_number_hashref_hashref' => 'possible_hashref_hashref_number',
           'possible_number_hashref_hashref_hashref' => 'possible_hashref_hashref_hashref_number',
           'possible_string_arrayref' => 'possible_arrayref_string',
           'possible_string_arrayref_arrayref' => 'possible_arrayref_arrayref_string',
           'possible_string_arrayref_arrayref_hashref' => 'possible_hashref_arrayref_arrayref_string',
           'possible_string_arrayref_hashref' => 'possible_hashref_arrayref_string',
           'possible_string_arrayref_hashref_hashref' => 'possible_hashref_hashref_arrayref_string',
           'possible_string_hashref' => 'possible_hashref_string',
           'possible_string_hashref_arrayref' => 'possible_arrayref_hashref_string',
           'possible_string_hashref_arrayref_hashref' => 'possible_hashref_arrayref_hashref_string',
           'possible_string_hashref_hashref' => 'possible_hashref_hashref_string',
           'possible_string_hashref_hashref_hashref' => 'possible_hashref_hashref_hashref_string',
           'string_arrayref' => 'arrayref_string',
           'string_arrayref_CHECK' => 'arrayref_string_CHECK',
           'string_arrayref_CHECKTRACE' => 'arrayref_string_CHECKTRACE',
           'string_arrayref_arrayref' => 'arrayref_arrayref_string',
           'string_arrayref_arrayref_CHECK' => 'arrayref_arrayref_string_CHECK',
           'string_arrayref_arrayref_CHECKTRACE' => 'arrayref_arrayref_string_CHECKTRACE',
           'string_arrayref_arrayref_const_iterator' => 'arrayref_arrayref_xtring_const_iterator',
           'string_arrayref_arrayref_hashref_CHECK' => 'hashref_arrayref_arrayref_string_CHECK',
           'string_arrayref_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_arrayref_string_CHECKTRACE',
           'string_arrayref_arrayref_iterator' => 'arrayref_arrayref_string_iterator',
           'string_arrayref_arrayref_to_string' => 'arrayref_arrayref_string_to_string',
           'string_arrayref_arrayref_typetest0' => 'arrayref_arrayref_string_typetest0',
           'string_arrayref_arrayref_typetest1' => 'arrayref_arrayref_string_typetest1',
           'string_arrayref_const_iterator' => 'arrayref_string_const_iterator',
           'string_arrayref_hashref' => 'hashref_arrayref_string',
           'string_arrayref_hashref_CHECK' => 'hashref_arrayref_string_CHECK',
           'string_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_string_CHECKTRACE',
           'string_arrayref_hashref_const_iterator' => 'hashref_arrayref_string_const_iterator',
           'string_arrayref_hashref_hashref' => 'hashref_hashref_arrayref_string',
           'string_arrayref_hashref_hashref_CHECK' => 'hashref_hashref_arrayref_string_CHECK',
           'string_arrayref_hashref_hashref_CHECKTRACE' => 'hashref_hashref_arrayref_string_CHECKTRACE',
           'string_arrayref_hashref_hashref_const_iterator' => 'hashref_hashref_arrayref_string_const_iterator',
           'string_arrayref_hashref_hashref_iterator' => 'hashref_hashref_arrayref_string_iterator',
           'string_arrayref_hashref_hashref_to_string' => 'hashref_hashref_arrayref_string_to_string',
           'string_arrayref_hashref_hashref_to_string_compact' => 'hashref_hashref_arrayref_string_to_string_compact',
           'string_arrayref_hashref_hashref_to_string_expand' => 'hashref_hashref_arrayref_string_to_string_expand',
           'string_arrayref_hashref_hashref_to_string_extend' => 'hashref_hashref_arrayref_string_to_string_extend',
           'string_arrayref_hashref_hashref_to_string_format' => 'hashref_hashref_arrayref_string_to_string_format',
           'string_arrayref_hashref_hashref_to_string_pretty' => 'hashref_hashref_arrayref_string_to_string_pretty',
           'string_arrayref_hashref_hashref_typetest0' => 'hashref_hashref_arrayref_string_typetest0',
           'string_arrayref_hashref_hashref_typetest1' => 'hashref_hashref_arrayref_string_typetest1',
           'string_arrayref_hashref_iterator' => 'hashref_arrayref_string_iterator',
           'string_arrayref_hashref_to_string' => 'hashref_arrayref_string_to_string',
           'string_arrayref_hashref_to_string_compact' => 'hashref_arrayref_string_to_string_compact',
           'string_arrayref_hashref_to_string_expand' => 'hashref_arrayref_string_to_string_expand',
           'string_arrayref_hashref_to_string_extend' => 'hashref_arrayref_string_to_string_extend',
           'string_arrayref_hashref_to_string_format' => 'hashref_arrayref_string_to_string_format',
           'string_arrayref_hashref_to_string_pretty' => 'hashref_arrayref_string_to_string_pretty',
           'string_arrayref_hashref_typetest0' => 'hashref_arrayref_string_typetest0',
           'string_arrayref_hashref_typetest1' => 'hashref_arrayref_string_typetest1',
           'string_arrayref_iterator' => 'arrayref_string_iterator',
           'string_arrayref_to_string' => 'arrayref_string_to_string',
           'string_arrayref_to_string_compact' => 'arrayref_string_to_string_compact',
           'string_arrayref_to_string_extend' => 'arrayref_string_to_string_extend',
           'string_arrayref_to_string_format' => 'arrayref_string_to_string_format',
           'string_arrayref_to_string_pretty' => 'arrayref_string_to_string_pretty',
           'string_arrayref_typetest0' => 'arrayref_string_typetest0',
           'string_arrayref_typetest1' => 'arrayref_string_typetest1',
           'string_hashref' => 'hashref_string',
           'string_hashref_CHECK' => 'hashref_string_CHECK',
           'string_hashref_CHECKTRACE' => 'hashref_string_CHECKTRACE',
           'string_hashref_arrayref' => 'arrayref_hashref_string',
           'string_hashref_arrayref_CHECK' => 'arrayref_hashref_string_CHECK',
           'string_hashref_arrayref_CHECKTRACE' => 'arrayref_hashref_string_CHECKTRACE',
           'string_hashref_arrayref_const_iterator' => 'arrayref_hashref_string_const_iterator',
           'string_hashref_arrayref_hashref_CHECK' => 'hashref_arrayref_hashref_string_CHECK',
           'string_hashref_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_hashref_string_CHECKTRACE',
           'string_hashref_arrayref_iterator' => 'arrayref_hashref_string_iterator',
           'string_hashref_arrayref_to_string' => 'arrayref_hashref_string_to_string',
           'string_hashref_arrayref_typetest0' => 'arrayref_hashref_string_typetest0',
           'string_hashref_arrayref_typetest1' => 'arrayref_hashref_string_typetest1',
           'string_hashref_const_iterator' => 'hashref_string_const_iterator',
           'string_hashref_hashref' => 'hashref_hashref_string',
           'string_hashref_hashref_CHECK' => 'hashref_hashref_string_CHECK',
           'string_hashref_hashref_CHECKTRACE' => 'hashref_hashref_string_CHECKTRACE',
           'string_hashref_hashref_const_iterator' => 'hashref_hashref_string_const_iterator',
           'string_hashref_hashref_hashref_CHECK' => 'hashref_hashref_hashref_string_CHECK',
           'string_hashref_hashref_hashref_CHECKTRACE' => 'hashref_hashref_hashref_string_CHECKTRACE',
           'string_hashref_hashref_iterator' => 'hashref_hashref_string_iterator',
           'string_hashref_hashref_to_string' => 'hashref_hashref_string_to_string',
           'string_hashref_hashref_typetest0' => 'hashref_hashref_string_typetest0',
           'string_hashref_hashref_typetest1' => 'hashref_hashref_string_typetest1',
           'string_hashref_iterator' => 'hashref_string_iterator',
           'string_hashref_to_string' => 'hashref_string_to_string',
           'string_hashref_to_string_compact' => 'hashref_string_to_string_compact',
           'string_hashref_to_string_expand' => 'hashref_string_to_string_expand',
           'string_hashref_to_string_format' => 'hashref_string_to_string_format',
           'string_hashref_to_string_pretty' => 'hashref_string_to_string_pretty',
           'string_hashref_typetest0' => 'hashref_string_typetest0',
           'string_hashref_typetest1' => 'hashref_string_typetest1'
         },
  'pm' => {
            'EIVAVRV00' => 'EAVRVIV00',
            'EIVAVRV01' => 'EAVRVIV01',
            'EIVAVRV02' => 'EAVRVIV02',
            'EIVAVRV03' => 'EAVRVIV03',
            'EIVAVRVHVRV00' => 'EHVRVAVRVIV00',
            'EIVAVRVHVRV01' => 'EHVRVAVRVIV01',
            'EIVAVRVHVRV02' => 'EHVRVAVRVIV02',
            'EIVAVRVHVRV03' => 'EHVRVAVRVIV03',
            'EIVAVRVHVRV04' => 'EHVRVAVRVIV04',
            'EIVAVRVHVRV05' => 'EHVRVAVRVIV05',
            'EIVHVRV00' => 'EHVRVIV00',
            'EIVHVRV01' => 'EHVRVIV01',
            'EIVHVRV02' => 'EHVRVIV02',
            'EIVHVRV03' => 'EHVRVIV03',
            'ENVAVRV00' => 'EAVRVNV00',
            'ENVAVRV01' => 'EAVRVNV01',
            'ENVAVRV02' => 'EAVRVNV02',
            'ENVAVRV03' => 'EAVRVNV03',
            'ENVAVRVHVRV00' => 'EHVRVAVRVNV00',
            'ENVAVRVHVRV01' => 'EHVRVAVRVNV01',
            'ENVAVRVHVRV02' => 'EHVRVAVRVNV02',
            'ENVAVRVHVRV03' => 'EHVRVAVRVNV03',
            'ENVAVRVHVRV04' => 'EHVRVAVRVNV04',
            'ENVAVRVHVRV05' => 'EHVRVAVRVNV05',
            'ENVHVRV00' => 'EHVRVNV00',
            'ENVHVRV01' => 'EHVRVNV01',
            'ENVHVRV02' => 'EHVRVNV02',
            'ENVHVRV03' => 'EHVRVNV03',
            'EPVAVRV00' => 'EAVRVPV00',
            'EPVAVRV01' => 'EAVRVPV01',
            'EPVAVRV02' => 'EAVRVPV02',
            'EPVAVRV03' => 'EAVRVPV03',
            'EPVAVRVHVRV00' => 'EHVRVAVRVPV00',
            'EPVAVRVHVRV01' => 'EHVRVAVRVPV01',
            'EPVAVRVHVRV02' => 'EHVRVAVRVPV02',
            'EPVAVRVHVRV03' => 'EHVRVAVRVPV03',
            'EPVAVRVHVRV04' => 'EHVRVAVRVPV04',
            'EPVAVRVHVRV05' => 'EHVRVAVRVPV05',
            'EPVHVRV00' => 'EHVRVPV00',
            'EPVHVRV01' => 'EHVRVPV01',
            'EPVHVRV02' => 'EHVRVPV02',
            'EPVHVRV03' => 'EHVRVPV03',
            'arrayref_arrayref' => 'arrayref::arrayref',
            'arrayref_arrayref_arrayref' => 'arrayref::arrayref::arrayref',
            'arrayref_arrayref_hashref' => 'hashref::arrayref::arrayref',
            'arrayref_hashref' => 'hashref::arrayref',
            'arrayref_hashref_hashref' => 'hashref::hashref::arrayref',
            'character_arrayref' => 'arrayref::character',
            'character_hashref' => 'hashref::character',
            'gsl_matrix_to_number_arrayref' => 'gsl_matrix_to_arrayref_number',
            'gsl_matrix_to_number_arrayref_arrayref' => 'gsl_matrix_to_arrayref_arrayref_number',
            'hashref_arrayref' => 'arrayref::hashref',
            'hashref_arrayref_hashref' => 'hashref::arrayref::hashref',
            'hashref_hashref' => 'hashref::hashref',
            'hashref_hashref_hashref' => 'hashref::hashref::hashref',
            'input_av_element' => 'input_av__element',
            'input_av_length' => 'input_av__length',
            'input_avref_hv' => 'input_hv_avref',
            'input_avref_hv_entry_value' => 'input_hv_avref__entry_value',
            'input_avref_hv_length' => 'input_hv_avref__length',
            'input_avref_hvref' => 'input_hvref_avref',
            'input_hv_entry_value' => 'input_hv__entry_value',
            'input_hv_length' => 'input_hv__length',
            'input_number_arrayref' => 'input_arrayref_number',
            'integer_arrayref' => 'arrayref::integer',
            'integer_arrayref_CHECK' => 'arrayref_integer_CHECK',
            'integer_arrayref_CHECKTRACE' => 'arrayref_integer_CHECKTRACE',
            'integer_arrayref_arrayref' => 'arrayref::arrayref::integer',
            'integer_arrayref_arrayref::method' => 'arrayref::arrayref::integer::method',
            'integer_arrayref_arrayref_CHECK' => 'arrayref_arrayref_integer_CHECK',
            'integer_arrayref_arrayref_arrayref' => 'arrayref::arrayref::arrayref::integer',
            'integer_arrayref_arrayref_hashref' => 'hashref::arrayref::arrayref::integer',
            'integer_arrayref_arrayref_to_string' => 'arrayref_arrayref_integer_to_string',
            'integer_arrayref_arrayref_typetest' => 'arrayref_arrayref_integer_typetest',
            'integer_arrayref_hashref' => 'hashref::arrayref::integer',
            'integer_arrayref_hashref_CHECK' => 'hashref_arrayref_integer_CHECK',
            'integer_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_integer_CHECKTRACE',
            'integer_arrayref_hashref_hashref' => 'hashref::hashref::arrayref::integer',
            'integer_arrayref_hashref_to_string' => 'hashref_arrayref_integer_to_string',
            'integer_arrayref_hashref_to_string_compact' => 'hashref_arrayref_integer_to_string_compact',
            'integer_arrayref_hashref_to_string_expand' => 'hashref_arrayref_integer_to_string_expand',
            'integer_arrayref_hashref_to_string_format' => 'hashref_arrayref_integer_to_string_format',
            'integer_arrayref_hashref_to_string_pretty' => 'hashref_arrayref_integer_to_string_pretty',
            'integer_arrayref_hashref_typetest0' => 'hashref_arrayref_integer_typetest0',
            'integer_arrayref_hashref_typetest1' => 'hashref_arrayref_integer_typetest1',
            'integer_arrayref_to_string' => 'arrayref_integer_to_string',
            'integer_arrayref_to_string_compact' => 'arrayref_integer_to_string_compact',
            'integer_arrayref_to_string_expand' => 'arrayref_integer_to_string_expand',
            'integer_arrayref_to_string_format' => 'arrayref_integer_to_string_format',
            'integer_arrayref_to_string_pretty' => 'arrayref_integer_to_string_pretty',
            'integer_arrayref_typetest0' => 'arrayref_integer_typetest0',
            'integer_arrayref_typetest1' => 'arrayref_integer_typetest1',
            'integer_hashref' => 'hashref::integer',
            'integer_hashref_CHECK' => 'hashref_integer_CHECK',
            'integer_hashref_CHECKTRACE' => 'hashref_integer_CHECKTRACE',
            'integer_hashref_arrayref_hashref' => 'hashref::arrayref::hashref::integer',
            'integer_hashref_hashref' => 'hashref::hashref::integer',
            'integer_hashref_hashref_hashref' => 'hashref::hashref::hashref::integer',
            'integer_hashref_to_string' => 'hashref_integer_to_string',
            'integer_hashref_to_string_compact' => 'hashref_integer_to_string_compact',
            'integer_hashref_to_string_expand' => 'hashref_integer_to_string_expand',
            'integer_hashref_to_string_format' => 'hashref_integer_to_string_format',
            'integer_hashref_to_string_pretty' => 'hashref_integer_to_string_pretty',
            'integer_hashref_typetest0' => 'hashref_integer_typetest0',
            'integer_hashref_typetest1' => 'hashref_integer_typetest1',
            'ninteger_arrayref' => 'narrayref_integer',
            'ninteger_hashref' => 'nhashref::integer',
            'nnumber_arrayref' => 'narrayref_number',
            'nnumber_hashref' => 'nhashref::number',
            'nstring_arrayref' => 'narrayref_string',
            'nstring_hashref' => 'nhashref::string',
            'number_arrayref' => 'arrayref::number',
            'number_arrayref_CHECK' => 'arrayref_number_CHECK',
            'number_arrayref_CHECKTRACE' => 'arrayref_number_CHECKTRACE',
            'number_arrayref_arrayref' => 'arrayref::arrayref::number',
            'number_arrayref_arrayref::method' => 'arrayref::arrayref::number::method',
            'number_arrayref_arrayref_arrayref' => 'arrayref::arrayref::arrayref::number',
            'number_arrayref_arrayref_hashref' => 'hashref::arrayref::arrayref::number',
            'number_arrayref_hashref' => 'hashref::arrayref::number',
            'number_arrayref_hashref_CHECK' => 'hashref_arrayref_number_CHECK',
            'number_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_number_CHECKTRACE',
            'number_arrayref_hashref_hashref' => 'hashref::hashref::arrayref::number',
            'number_arrayref_hashref_to_string' => 'hashref_arrayref_number_to_string',
            'number_arrayref_hashref_to_string_compact' => 'hashref_arrayref_number_to_string_compact',
            'number_arrayref_hashref_to_string_expand' => 'hashref_arrayref_number_to_string_expand',
            'number_arrayref_hashref_to_string_format' => 'hashref_arrayref_number_to_string_format',
            'number_arrayref_hashref_to_string_pretty' => 'hashref_arrayref_number_to_string_pretty',
            'number_arrayref_hashref_typetest0' => 'hashref_arrayref_number_typetest0',
            'number_arrayref_hashref_typetest1' => 'hashref_arrayref_number_typetest1',
            'number_arrayref_to_gsl_matrix' => 'arrayref_number_to_gsl_matrix',
            'number_arrayref_to_string' => 'arrayref_number_to_string',
            'number_arrayref_to_string_compact' => 'arrayref_number_to_string_compact',
            'number_arrayref_to_string_expand' => 'arrayref_number_to_string_expand',
            'number_arrayref_to_string_format' => 'arrayref_number_to_string_format',
            'number_arrayref_to_string_pretty' => 'arrayref_number_to_string_pretty',
            'number_arrayref_typetest0' => 'arrayref_number_typetest0',
            'number_arrayref_typetest1' => 'arrayref_number_typetest1',
            'number_hashref' => 'hashref::number',
            'number_hashref_CHECK' => 'hashref_number_CHECK',
            'number_hashref_CHECKTRACE' => 'hashref_number_CHECKTRACE',
            'number_hashref_arrayref_hashref' => 'hashref::arrayref::hashref::number',
            'number_hashref_hashref' => 'hashref::hashref::number',
            'number_hashref_hashref_hashref' => 'hashref::hashref::hashref::number',
            'number_hashref_to_string' => 'hashref_number_to_string',
            'number_hashref_to_string_compact' => 'hashref_number_to_string_compact',
            'number_hashref_to_string_expand' => 'hashref_number_to_string_expand',
            'number_hashref_to_string_format' => 'hashref_number_to_string_format',
            'number_hashref_to_string_pretty' => 'hashref_number_to_string_pretty',
            'number_hashref_typetest0' => 'hashref_number_typetest0',
            'number_hashref_typetest1' => 'hashref_number_typetest1',
            'object_arrayref' => 'arrayref::object',
            'object_hashref' => 'hashref::object',
            'possible_integer_arrayref' => 'possible_arrayref_integer',
            'possible_integer_arrayref_hashref' => 'possible_hashref_arrayref_integer',
            'possible_integer_hashref' => 'possible_hashref_integer',
            'possible_number_arrayref' => 'possible_arrayref_number',
            'possible_number_arrayref_hashref' => 'possible_hashref_arrayref_number',
            'possible_number_hashref' => 'possible_hashref_number',
            'possible_string_arrayref' => 'possible_arrayref_string',
            'possible_string_arrayref_hashref' => 'possible_hashref_arrayref_string',
            'possible_string_hashref' => 'possible_hashref_string',
            'scalartype_arrayref' => 'arrayref::scalartype',
            'scalartype_arrayref_arrayref' => 'arrayref::arrayref::scalartype',
            'scalartype_arrayref_arrayref::method' => 'arrayref::arrayref::scalartype::method',
            'scalartype_arrayref_arrayref_arrayref' => 'arrayref::arrayref::arrayref::scalartype',
            'scalartype_arrayref_arrayref_hashref' => 'hashref::arrayref::arrayref::scalartype',
            'scalartype_arrayref_hashref_hashref' => 'hashref::hashref::arrayref::scalartype',
            'scalartype_hashref' => 'hashref::scalartype',
            'scalartype_hashref_arrayref_hashref' => 'hashref::arrayref::hashref::scalartype',
            'scalartype_hashref_hashref' => 'hashref::hashref::scalartype',
            'scalartype_hashref_hashref_hashref' => 'hashref::hashref::hashref::scalartype',
            'string_arrayref' => 'arrayref::string',
            'string_arrayref_CHECK' => 'arrayref_string_CHECK',
            'string_arrayref_CHECKTRACE' => 'arrayref_string_CHECKTRACE',
            'string_arrayref_arrayref' => 'arrayref::arrayref::string',
            'string_arrayref_arrayref::method' => 'arrayref::arrayref::string::method',
            'string_arrayref_arrayref_arrayref' => 'arrayref::arrayref::arrayref::string',
            'string_arrayref_arrayref_hashref' => 'hashref::arrayref::arrayref::string',
            'string_arrayref_hashref' => 'hashref::arrayref::string',
            'string_arrayref_hashref_CHECK' => 'hashref_arrayref_string_CHECK',
            'string_arrayref_hashref_CHECKTRACE' => 'hashref_arrayref_string_CHECKTRACE',
            'string_arrayref_hashref_hashref' => 'hashref::hashref::arrayref::string',
            'string_arrayref_hashref_to_string' => 'hashref_arrayref_string_to_string',
            'string_arrayref_hashref_to_string_compact' => 'hashref_arrayref_string_to_string_compact',
            'string_arrayref_hashref_to_string_expand' => 'hashref_arrayref_string_to_string_expand',
            'string_arrayref_hashref_to_string_format' => 'hashref_arrayref_string_to_string_format',
            'string_arrayref_hashref_to_string_pretty' => 'hashref_arrayref_string_to_string_pretty',
            'string_arrayref_hashref_typetest0' => 'hashref_arrayref_string_typetest0',
            'string_arrayref_hashref_typetest1' => 'hashref_arrayref_string_typetest1',
            'string_arrayref_to_string' => 'arrayref_string_to_string',
            'string_arrayref_to_string_compact' => 'arrayref_string_to_string_compact',
            'string_arrayref_to_string_expand' => 'arrayref_string_to_string_expand',
            'string_arrayref_to_string_format' => 'arrayref_string_to_string_format',
            'string_arrayref_to_string_pretty' => 'arrayref_string_to_string_pretty',
            'string_arrayref_typetest0' => 'arrayref_string_typetest0',
            'string_arrayref_typetest1' => 'arrayref_string_typetest1',
            'string_hashref' => 'hashref::string',
            'string_hashref_CHECK' => 'hashref_string_CHECK',
            'string_hashref_CHECKTRACE' => 'hashref_string_CHECKTRACE',
            'string_hashref_arrayref_hashref' => 'hashref::arrayref::hashref::string',
            'string_hashref_hashref' => 'hashref::hashref::string',
            'string_hashref_hashref_hashref' => 'hashref::hashref::hashref::string',
            'string_hashref_to_string' => 'hashref_string_to_string',
            'string_hashref_to_string_compact' => 'hashref_string_to_string_compact',
            'string_hashref_to_string_expand' => 'hashref_string_to_string_expand',
            'string_hashref_to_string_format' => 'hashref_string_to_string_format',
            'string_hashref_to_string_pretty' => 'hashref_string_to_string_pretty',
            'string_hashref_typetest0' => 'hashref_string_typetest0',
            'string_hashref_typetest1' => 'hashref_string_typetest1'
          }
}
;
1;
